/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scripting;

import java.util.Map;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;
import org.springframework.integration.scripting.ScriptExecutor;
import org.springframework.integration.scripting.ScriptingException;
import org.springframework.lang.Nullable;
import org.springframework.scripting.ScriptSource;
import org.springframework.util.Assert;

public class PolyglotScriptExecutor
implements ScriptExecutor {
    private final String language;
    private Context.Builder contextBuilder;

    public PolyglotScriptExecutor(String language) {
        this(language, Context.newBuilder((String[])new String[0]).allowAllAccess(true));
    }

    public PolyglotScriptExecutor(String language, Context.Builder contextBuilder) {
        Assert.hasText((String)language, (String)"'language' must not be empty");
        Assert.notNull((Object)contextBuilder, (String)"'contextBuilder' must not be null");
        this.contextBuilder = contextBuilder;
        this.language = language;
        try (Context context = this.contextBuilder.build();){
            context.initialize(language);
        }
    }

    @Override
    public Object executeScript(ScriptSource scriptSource, @Nullable Map<String, Object> variables) {
        Object object;
        block9: {
            Context context = this.contextBuilder.build();
            try {
                if (variables != null) {
                    Value bindings = context.getBindings(this.language);
                    variables.forEach((arg_0, arg_1) -> ((Value)bindings).putMember(arg_0, arg_1));
                }
                object = context.eval(this.language, (CharSequence)scriptSource.getScriptAsString()).as(Object.class);
                if (context == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new ScriptingException(ex.getMessage(), ex);
                }
            }
            context.close();
        }
        return object;
    }
}

