/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.security.channel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.integration.security.channel.ChannelAccessPolicy;
import org.springframework.integration.security.channel.ChannelInvocation;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.messaging.MessageChannel;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityMetadataSource;
import org.springframework.util.Assert;

@Deprecated(since="6.0")
public class ChannelSecurityMetadataSource
implements SecurityMetadataSource {
    private final Map<Pattern, ChannelAccessPolicy> patternMappings;

    public ChannelSecurityMetadataSource() {
        this(null);
    }

    public ChannelSecurityMetadataSource(Map<Pattern, ChannelAccessPolicy> patternMappings) {
        this.patternMappings = patternMappings != null ? patternMappings : new LinkedHashMap();
    }

    public void addPatternMapping(Pattern pattern, ChannelAccessPolicy accessPolicy) {
        this.patternMappings.put(pattern, accessPolicy);
    }

    public Set<Pattern> getPatterns() {
        return this.patternMappings.keySet();
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        Assert.isAssignable(ChannelInvocation.class, object.getClass());
        ChannelInvocation invocation = (ChannelInvocation)object;
        MessageChannel channel = invocation.getChannel();
        Assert.isAssignable(NamedComponent.class, channel.getClass());
        String channelName = ((NamedComponent)channel).getComponentName();
        ArrayList<ConfigAttribute> attributes = new ArrayList<ConfigAttribute>();
        for (Map.Entry<Pattern, ChannelAccessPolicy> mapping : this.patternMappings.entrySet()) {
            Collection<ConfigAttribute> definition;
            Pattern pattern = mapping.getKey();
            ChannelAccessPolicy accessPolicy = mapping.getValue();
            if (!pattern.matcher(channelName).matches()) continue;
            if (invocation.isSend()) {
                definition = accessPolicy.getConfigAttributesForSend();
                if (definition == null) continue;
                attributes.addAll(definition);
                continue;
            }
            if (!invocation.isReceive() || (definition = accessPolicy.getConfigAttributesForReceive()) == null) continue;
            attributes.addAll(definition);
        }
        return attributes;
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        HashSet<ConfigAttribute> allAttributes = new HashSet<ConfigAttribute>();
        for (ChannelAccessPolicy policy : this.patternMappings.values()) {
            Collection<ConfigAttribute> receiveAttributes = policy.getConfigAttributesForReceive();
            allAttributes.addAll(receiveAttributes);
            Collection<ConfigAttribute> sendAttributes = policy.getConfigAttributesForSend();
            allAttributes.addAll(sendAttributes);
        }
        return allAttributes;
    }

    public boolean supports(Class<?> clazz) {
        return ChannelInvocation.class.isAssignableFrom(clazz);
    }
}

