/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.session;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sshd.client.config.hosts.KnownHostEntry;
import org.apache.sshd.client.keyverifier.KnownHostsServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class ResourceKnownHostsServerKeyVerifier
implements ServerKeyVerifier {
    private static final Log logger = LogFactory.getLog(ResourceKnownHostsServerKeyVerifier.class);
    private final Supplier<Collection<KnownHostsServerKeyVerifier.HostEntryPair>> keysSupplier;

    public ResourceKnownHostsServerKeyVerifier(Resource knownHostsResource) {
        Assert.notNull((Object)knownHostsResource, (String)"'knownHostsResource' must not be null");
        this.keysSupplier = GenericUtils.memoizeLock(ResourceKnownHostsServerKeyVerifier.getKnownHostSupplier(knownHostsResource));
    }

    public boolean verifyServerKey(ClientSession clientSession, SocketAddress remoteAddress, PublicKey serverKey) {
        Collection<KnownHostsServerKeyVerifier.HostEntryPair> knownHosts = this.keysSupplier.get();
        KnownHostsServerKeyVerifier.HostEntryPair match = ResourceKnownHostsServerKeyVerifier.findKnownHostEntry(clientSession, remoteAddress, knownHosts);
        if (match == null) {
            return false;
        }
        KnownHostEntry entry = match.getHostEntry();
        PublicKey expected = match.getServerKey();
        if (KeyUtils.compareKeys((PublicKey)expected, (PublicKey)serverKey)) {
            return !"revoked".equals(entry.getMarker());
        }
        return false;
    }

    private static Supplier<Collection<KnownHostsServerKeyVerifier.HostEntryPair>> getKnownHostSupplier(Resource knownHostsResource) {
        return () -> {
            try {
                List entries = KnownHostEntry.readKnownHostEntries((InputStream)knownHostsResource.getInputStream(), (boolean)true);
                ArrayList<KnownHostsServerKeyVerifier.HostEntryPair> keys = new ArrayList<KnownHostsServerKeyVerifier.HostEntryPair>(entries.size());
                for (KnownHostEntry entry : entries) {
                    keys.add(new KnownHostsServerKeyVerifier.HostEntryPair(entry, ResourceKnownHostsServerKeyVerifier.resolveHostKey(entry)));
                }
                return keys;
            }
            catch (Exception ex) {
                logger.warn((Object)("Known hosts cannot be loaded from the: " + knownHostsResource), (Throwable)ex);
                return Collections.emptyList();
            }
        };
    }

    private static PublicKey resolveHostKey(KnownHostEntry entry) throws IOException, GeneralSecurityException {
        AuthorizedKeyEntry authEntry = entry.getKeyEntry();
        Assert.notNull((Object)authEntry, () -> "No key extracted from " + entry);
        return authEntry.resolvePublicKey(null, PublicKeyEntryResolver.IGNORING);
    }

    private static KnownHostsServerKeyVerifier.HostEntryPair findKnownHostEntry(ClientSession clientSession, SocketAddress remoteAddress, Collection<KnownHostsServerKeyVerifier.HostEntryPair> knownHosts) {
        Collection<SshdSocketAddress> candidates = ResourceKnownHostsServerKeyVerifier.resolveHostNetworkIdentities(clientSession, remoteAddress);
        if (GenericUtils.isEmpty(candidates)) {
            return null;
        }
        for (KnownHostsServerKeyVerifier.HostEntryPair match : knownHosts) {
            KnownHostEntry entry = match.getHostEntry();
            for (SshdSocketAddress host : candidates) {
                if (!entry.isHostMatch(host.getHostName(), host.getPort())) continue;
                return match;
            }
        }
        return null;
    }

    private static Collection<SshdSocketAddress> resolveHostNetworkIdentities(ClientSession clientSession, SocketAddress remoteAddress) {
        TreeSet<SshdSocketAddress> candidates = new TreeSet<SshdSocketAddress>(SshdSocketAddress.BY_HOST_AND_PORT);
        candidates.add(SshdSocketAddress.toSshdSocketAddress((SocketAddress)remoteAddress));
        SocketAddress connectAddress = clientSession.getConnectAddress();
        candidates.add(SshdSocketAddress.toSshdSocketAddress((SocketAddress)connectAddress));
        return candidates;
    }
}

