/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.smb.session;

import java.net.URI;
import java.net.URISyntaxException;
import jcifs.DialectVersion;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SmbConfig {
    private String host;
    private int port;
    private String domain;
    private String username;
    private String password;
    private String shareAndDir;
    private boolean replaceFile = false;
    private boolean useTempFile = false;
    private DialectVersion smbMinVersion = DialectVersion.SMB1;
    private DialectVersion smbMaxVersion = DialectVersion.SMB210;

    public SmbConfig() {
    }

    public SmbConfig(String _host, int _port, String _domain, String _username, String _password, String _shareAndDir) {
        this.setHost(_host);
        this.setPort(_port);
        this.setDomain(_domain);
        this.setUsername(_username);
        this.setPassword(_password);
        this.setShareAndDir(_shareAndDir);
    }

    public void setHost(String _host) {
        Assert.hasText((String)_host, (String)"host must not be empty");
        this.host = _host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int _port) {
        Assert.isTrue((_port >= 0 ? 1 : 0) != 0, (String)"port must be >= 0");
        this.port = _port;
    }

    public int getPort() {
        return this.port;
    }

    public void setDomain(String _domain) {
        Assert.notNull((Object)_domain, (String)"_domain can't be null");
        this.domain = _domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setUsername(String _username) {
        Assert.hasText((String)_username, (String)"username should be a non-empty string");
        this.username = _username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String _password) {
        Assert.notNull((Object)_password, (String)"password should not be null");
        this.password = _password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setShareAndDir(String _shareAndDir) {
        Assert.notNull((Object)_shareAndDir, (String)"shareAndDir should not be null");
        this.shareAndDir = _shareAndDir;
    }

    public String getShareAndDir() {
        return this.shareAndDir;
    }

    public void setReplaceFile(boolean _replaceFile) {
        this.replaceFile = _replaceFile;
    }

    public boolean isReplaceFile() {
        return this.replaceFile;
    }

    void setUseTempFile(boolean _useTempFile) {
        this.useTempFile = _useTempFile;
    }

    public boolean isUseTempFile() {
        return this.useTempFile;
    }

    public DialectVersion getSmbMinVersion() {
        return this.smbMinVersion;
    }

    public void setSmbMinVersion(DialectVersion _smbMinVersion) {
        this.smbMinVersion = _smbMinVersion;
    }

    public DialectVersion getSmbMaxVersion() {
        return this.smbMaxVersion;
    }

    public void setSmbMaxVersion(DialectVersion _smbMaxVersion) {
        this.smbMaxVersion = _smbMaxVersion;
    }

    String getDomainUserPass(boolean _includePassword) {
        String domainUserPass = StringUtils.hasText((String)this.domain) ? String.format("%s;%s", this.domain, this.username) : this.username;
        if (StringUtils.hasText((String)this.password)) {
            domainUserPass = domainUserPass + ":" + (_includePassword ? this.password : "********");
        }
        return domainUserPass;
    }

    String getHostPort() {
        return this.host + (this.port > 0 ? String.format(":%d", this.port) : "");
    }

    public final SmbConfig validate() {
        Assert.hasText((String)this.getHost(), (String)("host must not be empty in " + this));
        Assert.isTrue((this.getPort() >= 0 ? 1 : 0) != 0, (String)("port must be >= 0 in " + this));
        Assert.hasText((String)this.getShareAndDir(), (String)("share must not be empty in " + this));
        return this;
    }

    public final String getUrl() {
        return this.getUrl(true);
    }

    public final String getUrl(boolean _includePassword) {
        String domainUserPass = this.getDomainUserPass(_includePassword);
        String path = StringUtils.cleanPath((String)this.shareAndDir);
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        try {
            return new URI("smb", domainUserPass, this.host, this.port, path, null, null).toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[url=" + this.getUrl(false) + ", replaceFile=" + this.replaceFile + "]";
    }
}

