/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.smb.session;

import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import jcifs.CIFSContext;
import jcifs.Configuration;
import jcifs.Credentials;
import jcifs.config.PropertyConfiguration;
import jcifs.context.BaseContext;
import jcifs.context.SingletonContext;
import jcifs.smb.NtlmPasswordAuthenticator;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.NestedIOException;
import org.springframework.integration.smb.session.SmbConfig;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SmbShare
extends SmbFile {
    private static final Log logger = LogFactory.getLog(SmbShare.class);
    private final AtomicBoolean open = new AtomicBoolean(false);
    private final AtomicBoolean replaceFile = new AtomicBoolean(false);
    private final AtomicBoolean useTempFile = new AtomicBoolean(false);

    @Deprecated
    public SmbShare(String url) throws IOException {
        super(StringUtils.cleanPath((String)url));
    }

    public SmbShare(SmbConfig _smbConfig) throws IOException {
        super(StringUtils.cleanPath((String)_smbConfig.validate().getUrl()), SingletonContext.getInstance().withCredentials((Credentials)new NtlmPasswordAuthenticator(_smbConfig.getDomain(), _smbConfig.getUsername(), _smbConfig.getPassword())));
    }

    public SmbShare(SmbConfig _smbConfig, CIFSContext _context) throws IOException {
        super(StringUtils.cleanPath((String)_smbConfig.validate().getUrl()), _context);
    }

    public SmbShare(SmbConfig _smbConfig, Properties _props) throws IOException {
        super(StringUtils.cleanPath((String)_smbConfig.validate().getUrl()), new BaseContext((Configuration)new PropertyConfiguration(_props)).withCredentials((Credentials)new NtlmPasswordAuthenticator(_smbConfig.getDomain(), _smbConfig.getUsername(), _smbConfig.getPassword())));
    }

    public void init() throws NestedIOException {
        boolean canRead = false;
        try {
            if (!this.exists()) {
                logger.info((Object)"SMB root directory does not exist. Creating it.");
                this.mkdirs();
            }
            canRead = this.canRead();
        }
        catch (SmbException _ex) {
            throw new NestedIOException("Unable to initialize share: " + (Object)((Object)this), (Throwable)_ex);
        }
        Assert.isTrue((boolean)canRead, (String)("Share is not accessible " + (Object)((Object)this)));
        this.open.set(true);
    }

    public boolean isReplaceFile() {
        return this.replaceFile.get();
    }

    public void setReplaceFile(boolean _replace) {
        this.replaceFile.set(_replace);
    }

    public boolean isUseTempFile() {
        return this.useTempFile.get();
    }

    public void setUseTempFile(boolean _useTempFile) {
        this.useTempFile.set(_useTempFile);
    }

    boolean isOpened() {
        return this.open.get();
    }

    void doClose() {
        this.open.set(false);
    }

    public String newTempFileSuffix() {
        return "-" + Long.toHexString(Double.doubleToLongBits(Math.random())) + ".tmp";
    }
}

