/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.smb.session;

import java.io.IOException;
import jcifs.internal.dtyp.ACE;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.util.Assert;

public class SmbFileInfo
extends AbstractFileInfo<SmbFile> {
    private static final Log logger = LogFactory.getLog(SmbFileInfo.class);
    private final SmbFile smbFile;

    public SmbFileInfo(SmbFile smbFile) {
        Assert.notNull((Object)smbFile, (String)"SmbFile must not be null");
        this.smbFile = smbFile;
    }

    public boolean isDirectory() {
        try {
            return this.smbFile.isDirectory();
        }
        catch (SmbException se) {
            logger.error((Object)"Unable to determine if this SmbFile represents a directory", (Throwable)se);
            return false;
        }
    }

    public boolean isLink() {
        return false;
    }

    public long getSize() {
        try {
            return this.smbFile.length();
        }
        catch (SmbException se) {
            logger.error((Object)"Unable to determine file size", (Throwable)se);
            return 0L;
        }
    }

    public long getModified() {
        return this.smbFile.getLastModified();
    }

    public String getFilename() {
        return this.smbFile.getName();
    }

    public String getPermissions() {
        ACE[] aces;
        try {
            aces = this.smbFile.getSecurity(true);
        }
        catch (IOException ioe) {
            logger.error((Object)"Unable to determine security descriptor information for this SmbFile", (Throwable)ioe);
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (ACE ace : aces) {
            sb.append(ace.getSID().toDisplayString());
            sb.append(" - ");
            if ((ace.getAccessMask() & 1) != 0) {
                sb.append(SmbFileInfo.aceToAllowFlag(ace));
                sb.append("Read, ");
            }
            if ((ace.getAccessMask() & 2) != 0) {
                sb.append(SmbFileInfo.aceToAllowFlag(ace));
                sb.append("Write, ");
            }
            if ((ace.getAccessMask() & 4) != 0) {
                sb.append(SmbFileInfo.aceToAllowFlag(ace));
                sb.append("Modify, ");
            }
            if ((ace.getAccessMask() & 0x20) != 0) {
                sb.append(SmbFileInfo.aceToAllowFlag(ace));
                sb.append("Execute, ");
            }
            if ((ace.getAccessMask() & 0x40) != 0 || (ace.getAccessMask() & 0x10000) != 0) {
                sb.append(SmbFileInfo.aceToAllowFlag(ace));
                sb.append("Delete, ");
            }
            sb.append(ace.isInherited() ? "Inherited - " : "Direct - ");
            sb.append(ace.getApplyToText());
            sb.append("\n");
        }
        logger.debug((Object)this.getFilename());
        logger.debug((Object)sb);
        return sb.toString();
    }

    private static String aceToAllowFlag(ACE ace) {
        return ace.isAllow() ? "Allow " : "Deny ";
    }

    public SmbFile getFileInfo() {
        return this.smbFile;
    }
}

