/*
 * Copyright 2002-2013 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package org.springframework.integration.splunk.event;

/**
 * @author David Turanski
 *
 */
@SuppressWarnings("serial")
public class MalwareEndpointProtectionEvent extends SplunkEvent {
	// ----------------------------------
	// Malware - Endpoint protection
	// ----------------------------------

	/**
	 * The outcome of the infection
	 */
	public static String MALWARE_ENDPOINT_PROTECTION_ACTION = "action";
	/**
	 * The NT domain of the destination (the dest_bestmatch).
	 */
	public static String MALWARE_ENDPOINT_PROTECTION_DEST_NT_DOMAIN = "dest_nt_domain";
	/**
	 * The cryptographic hash of the file associated with the malware event
	 * (such as the malicious or infected file).
	 */
	public static String MALWARE_ENDPOINT_PROTECTION_FILE_HASH = "file_hash";
	/**
	 * The name of the file involved in the malware event (such as the infected
	 * or malicious file).
	 */
	public static String MALWARE_ENDPOINT_PROTECTION_FILE_NAME = "file_name";
	/**
	 * The path of the file involved in the malware event (such as the infected
	 * or malicious file).
	 */
	public static String MALWARE_ENDPOINT_PROTECTION_FILE_PATH = "file_path";
	/**
	 * The product name of the vendor technology (the vendor field) that is
	 * generating malware data (such as Antivirus or EPO).
	 */
	public static String MALWARE_ENDPOINT_PROTECTION_PRODUCT = "product";
	/**
	 * The product version number of the vendor technology installed on the
	 * client (such as 10.4.3 or 11.0.2).
	 */
	public static String MALWARE_ENDPOINT_PROTECTION_PRODUCT_VERSION = "product_version";
	/**
	 * The name of the malware infection detected on the client (the src), such
	 * as Trojan.Vundo,Spyware.Gaobot,W32.Nimbda).
	 *
	 * Note: This field is a string. Please use a signature_id field for
	 * signature ID fields that are integer data types.
	 */
	public static String MALWARE_ENDPOINT_PROTECTION_SIGNATURE = "signature";
	/**
	 * The current signature definition set running on the client, such as
	 * 11hsvx)
	 */
	public static String MALWARE_ENDPOINT_PROTECTION_SIGNATURE_VERSION = "signature_version";
	/**
	 * The target affected or infected by the malware. If your field is named
	 * dest_host, dest_ip, dest_ipv6, or dest_nt_host you can alias it as dest
	 * to make it CIM-compliant.
	 */
	public static String MALWARE_ENDPOINT_PROTECTION_DEST = "dest";
	/**
	 * The NT domain of the source (the src).
	 */
	public static String MALWARE_ENDPOINT_PROTECTION_SRC_NT_DOMAIN = "src_nt_domain";
	/**
	 * The name of the user involved in the malware event.
	 */
	public static String MALWARE_ENDPOINT_PROTECTION_USER = "user";
	/**
	 * The name of the vendor technology generating malware data, such as
	 * Symantec or McAfee.
	 */
	public static String MALWARE_ENDPOINT_PROTECTION_VENDOR = "vendor";

	public void setMalwareEndpointProtectionAction(String malwareEndpointProtectionAction) {
		addPair(MALWARE_ENDPOINT_PROTECTION_ACTION, malwareEndpointProtectionAction);
	}

	public void setMalwareEndpointProtectionDestNtDomain(String malwareEndpointProtectionDestNtDomain) {
		addPair(MALWARE_ENDPOINT_PROTECTION_DEST_NT_DOMAIN, malwareEndpointProtectionDestNtDomain);
	}

	public void setMalwareEndpointProtectionFileHash(String malwareEndpointProtectionFileHash) {
		addPair(MALWARE_ENDPOINT_PROTECTION_FILE_HASH, malwareEndpointProtectionFileHash);
	}

	public void setMalwareEndpointProtectionFileName(String malwareEndpointProtectionFileName) {
		addPair(MALWARE_ENDPOINT_PROTECTION_FILE_NAME, malwareEndpointProtectionFileName);
	}

	public void setMalwareEndpointProtectionFilePath(String malwareEndpointProtectionFilePath) {
		addPair(MALWARE_ENDPOINT_PROTECTION_FILE_PATH, malwareEndpointProtectionFilePath);
	}

	public void setMalwareEndpointProtectionProduct(String malwareEndpointProtectionProduct) {
		addPair(MALWARE_ENDPOINT_PROTECTION_PRODUCT, malwareEndpointProtectionProduct);
	}

	public void setMalwareEndpointProtectionProductVersion(String malwareEndpointProtectionProductVersion) {
		addPair(MALWARE_ENDPOINT_PROTECTION_PRODUCT_VERSION, malwareEndpointProtectionProductVersion);
	}

	public void setMalwareEndpointProtectionSignature(String malwareEndpointProtectionSignature) {
		addPair(MALWARE_ENDPOINT_PROTECTION_SIGNATURE, malwareEndpointProtectionSignature);
	}

	public void setMalwareEndpointProtectionSignatureVersion(String malwareEndpointProtectionSignatureVersion) {
		addPair(MALWARE_ENDPOINT_PROTECTION_SIGNATURE_VERSION, malwareEndpointProtectionSignatureVersion);
	}

	public void setMalwareEndpointProtectionDest(String malwareEndpointProtectionDest) {
		addPair(MALWARE_ENDPOINT_PROTECTION_DEST, malwareEndpointProtectionDest);
	}

	public void setMalwareEndpointProtectionSrcNtDomain(String malwareEndpointProtectionSrcNtDomain) {
		addPair(MALWARE_ENDPOINT_PROTECTION_SRC_NT_DOMAIN, malwareEndpointProtectionSrcNtDomain);
	}

	public void setMalwareEndpointProtectionUser(String malwareEndpointProtectionUser) {
		addPair(MALWARE_ENDPOINT_PROTECTION_USER, malwareEndpointProtectionUser);
	}

	public void setMalwareEndpointProtectionVendor(String malwareEndpointProtectionVendor) {
		addPair(MALWARE_ENDPOINT_PROTECTION_VENDOR, malwareEndpointProtectionVendor);
	}

}
