/*
 * Copyright 2002-2013 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package org.springframework.integration.splunk.event;

/**
 * @author David Turanski
 *
 */
@SuppressWarnings("serial")
public class MalwareNetworkProtectionEvent extends SplunkEvent {

	// ----------------------------------
	// Malware - Network protection
	// ----------------------------------

	/**
	 * The product name of the vendor technology generating network protection
	 * data, such as IDP, Proventia, and ASA.
	 *
	 * Note: Required for all events dealing with network protection (Change
	 * analysis, proxy, malware, intrusion detection, packet filtering, and
	 * vulnerability).
	 */
	public static String MALWARE_NETWORK_PROTECTION_PRODUCT = "product";
	/**
	 * The severity of the network protection event (such as critical, high,
	 * medium, low, or informational).
	 *
	 * Note: This field is a string. Please use a severity_id field for severity
	 * ID fields that are integer data types.
	 */
	public static String MALWARE_NETWORK_PROTECTION_SEVERITY = "severity";
	/**
	 * The vendor technology used to generate network protection data, such as
	 * IDP, Proventia, and ASA.
	 *
	 * Note: Required for all events dealing with network protection (Change
	 * analysis, proxy, malware, intrusion detection, packet filtering, and
	 * vulnerability).
	 */
	public static String MALWARE_NETWORK_PROTECTION_VENDOR = "vendor";

	public void setMalwareNetworkProtectionProduct(String malwareNetworkProtectionProduct) {
		addPair(MALWARE_NETWORK_PROTECTION_PRODUCT, malwareNetworkProtectionProduct);
	}

	public void setMalwareNetworkProtectionSeverity(String malwareNetworkProtectionSeverity) {
		addPair(MALWARE_NETWORK_PROTECTION_SEVERITY, malwareNetworkProtectionSeverity);
	}

	public void setMalwareNetworkProtectionVendor(String malwareNetworkProtectionVendor) {
		addPair(MALWARE_NETWORK_PROTECTION_VENDOR, malwareNetworkProtectionVendor);
	}
}
