/*
 * Copyright 2002-2013 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package org.springframework.integration.splunk.event;

/**
 * @author David Turanski
 *
 */
@SuppressWarnings("serial")
public class VulnerabilityEvent extends SplunkEvent {
	// ----------------------------------
	// Vulnerability
	// ----------------------------------

	/**
	 * The category of the discovered vulnerability.
	 */
	public static String VULNERABILITY_CATEGORY = "category";
	/**
	 * The host with the discovered vulnerability. If your field is named
	 * dest_host, dest_ip, dest_ipv6, or dest_nt_host you can alias it as dest
	 * to make it CIM-compliant.
	 */
	public static String VULNERABILITY_DEST = "dest";
	/**
	 * The operating system of the host containing the vulnerability detected on
	 * the client (the src field), such as SuSE Security Update, or cups
	 * security update.
	 */
	public static String VULNERABILITY_OS = "os";
	/**
	 * The severity of the discovered vulnerability.
	 */
	public static String VULNERABILITY_SEVERITY = "severity";
	/**
	 * The name of the vulnerability detected on the client (the src field),
	 * such as SuSE Security Update, or cups security update.
	 */
	public static String VULNERABILITY_SIGNATURE = "signature";

	public void setVulnerabilityCategory(String vulnerabilityCategory) {
		addPair(VULNERABILITY_CATEGORY, vulnerabilityCategory);
	}

	public void setVulnerabilityDest(String vulnerabilityDest) {
		addPair(VULNERABILITY_DEST, vulnerabilityDest);
	}

	public void setVulnerabilityOs(String vulnerabilityOs) {
		addPair(VULNERABILITY_OS, vulnerabilityOs);
	}

	public void setVulnerabilitySeverity(String vulnerabilitySeverity) {
		addPair(VULNERABILITY_SEVERITY, vulnerabilitySeverity);
	}

	public void setVulnerabilitySignature(String vulnerabilitySignature) {
		addPair(VULNERABILITY_SIGNATURE, vulnerabilitySignature);
	}
}
