/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.stomp;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.stomp.StompSessionManager;
import org.springframework.integration.stomp.event.StompConnectionFailedEvent;
import org.springframework.integration.stomp.event.StompSessionConnectedEvent;
import org.springframework.lang.Nullable;
import org.springframework.messaging.simp.stomp.StompClientSupport;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.messaging.simp.stomp.StompSessionHandlerAdapter;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class AbstractStompSessionManager
implements StompSessionManager,
ApplicationEventPublisherAware,
SmartLifecycle,
DisposableBean,
BeanNameAware {
    private static final long DEFAULT_RECOVERY_INTERVAL = 10000L;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final StompClientSupport stompClient;
    private final CompositeStompSessionHandler compositeStompSessionHandler = new CompositeStompSessionHandler();
    private final Lock lifecycleMonitor = new ReentrantLock();
    private final Lock lock = new ReentrantLock();
    private final AtomicInteger epoch = new AtomicInteger();
    private boolean autoStartup = false;
    private boolean running = false;
    private int phase = 0x3FFFFFFF;
    private ApplicationEventPublisher applicationEventPublisher;
    private StompHeaders connectHeaders;
    private boolean autoReceipt;
    private long recoveryInterval = 10000L;
    private String name;
    private volatile boolean connecting;
    private volatile boolean connected;
    private volatile CompletableFuture<StompSession> stompSessionFuture;
    private volatile ScheduledFuture<?> reconnectFuture;

    public AbstractStompSessionManager(StompClientSupport stompClient) {
        Assert.notNull((Object)stompClient, (String)"'stompClient' is required.");
        this.stompClient = stompClient;
    }

    public void setConnectHeaders(StompHeaders connectHeaders) {
        this.connectHeaders = connectHeaders;
    }

    public void setAutoReceipt(boolean autoReceipt) {
        this.autoReceipt = autoReceipt;
    }

    @Override
    public boolean isAutoReceiptEnabled() {
        return this.autoReceipt;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public void setRecoveryInterval(int recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public long getRecoveryInterval() {
        return this.recoveryInterval;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return this.phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        this.lock.lock();
        try {
            if (this.connecting || this.connected) {
                this.logger.debug((Object)"Aborting connect; another thread is connecting.");
                return;
            }
            int currentEpoch = this.epoch.get();
            this.connecting = true;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Connecting " + String.valueOf(this)));
            }
            try {
                this.stompSessionFuture = this.doConnect((StompSessionHandler)this.compositeStompSessionHandler);
            }
            catch (Exception e) {
                if (currentEpoch == this.epoch.get()) {
                    this.scheduleReconnect(e);
                } else {
                    this.logger.error((Object)("STOMP doConnect() error for " + String.valueOf(this)), (Throwable)e);
                }
                this.lock.unlock();
                return;
            }
            CountDownLatch connectLatch = this.addStompSessionCallback(currentEpoch);
            try {
                if (!connectLatch.await(30L, TimeUnit.SECONDS)) {
                    this.logger.error((Object)"No response to connection attempt");
                    if (currentEpoch == this.epoch.get()) {
                        this.scheduleReconnect(null);
                    }
                }
            }
            catch (InterruptedException e1) {
                this.logger.error((Object)"Interrupted while waiting for connection attempt");
                Thread.currentThread().interrupt();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private CountDownLatch addStompSessionCallback(int currentEpoch) {
        CountDownLatch connectLatch = new CountDownLatch(1);
        this.stompSessionFuture.whenComplete((stompSession, throwable) -> {
            if (throwable == null) {
                this.logger.debug((Object)"onSuccess");
                this.connected = true;
                this.connecting = false;
                if (stompSession != null) {
                    stompSession.setAutoReceipt(this.isAutoReceiptEnabled());
                }
                if (this.applicationEventPublisher != null) {
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)new StompSessionConnectedEvent(this));
                }
                this.reconnectFuture = null;
                connectLatch.countDown();
            } else {
                this.logger.debug((Object)"onFailure", throwable);
                connectLatch.countDown();
                if (currentEpoch == this.epoch.get()) {
                    this.scheduleReconnect((Throwable)throwable);
                }
            }
        });
        return connectLatch;
    }

    private void scheduleReconnect(Throwable e) {
        TaskScheduler taskScheduler;
        this.epoch.incrementAndGet();
        this.connecting = false;
        this.connected = false;
        if (e != null) {
            this.logger.error((Object)("STOMP connect error for " + String.valueOf(this)), e);
        }
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new StompConnectionFailedEvent(this, e));
        }
        if (this.reconnectFuture != null) {
            this.reconnectFuture.cancel(true);
            this.reconnectFuture = null;
        }
        if ((taskScheduler = this.stompClient.getTaskScheduler()) != null) {
            this.reconnectFuture = taskScheduler.schedule(this::connect, Instant.now().plusMillis(this.recoveryInterval));
        } else {
            this.logger.info((Object)"For automatic reconnection the stompClient should be configured with a TaskScheduler.");
        }
    }

    public void destroy() {
        if (this.stompSessionFuture != null) {
            if (this.reconnectFuture != null) {
                this.reconnectFuture.cancel(false);
                this.reconnectFuture = null;
            }
            this.stompSessionFuture.whenComplete((BiConsumer)new BiConsumer<StompSession, Throwable>(){

                @Override
                public void accept(StompSession session, Throwable throwable) {
                    if (session != null) {
                        session.disconnect();
                    }
                    AbstractStompSessionManager.this.connected = false;
                }
            });
            this.stompSessionFuture = null;
        }
    }

    public void start() {
        this.lifecycleMonitor.lock();
        try {
            if (!this.isRunning()) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Starting " + String.valueOf(this)));
                }
                this.connect();
                this.running = true;
            }
        }
        finally {
            this.lifecycleMonitor.unlock();
        }
    }

    public void stop() {
        this.lifecycleMonitor.lock();
        try {
            if (this.isRunning()) {
                this.running = false;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Stopping " + String.valueOf(this)));
                }
                this.destroy();
            }
        }
        finally {
            this.lifecycleMonitor.unlock();
        }
    }

    @Override
    public void connect(StompSessionHandler handler) {
        this.compositeStompSessionHandler.addHandler(handler);
        if (!this.isConnected() && !this.connecting) {
            if (this.reconnectFuture != null) {
                this.reconnectFuture.cancel(true);
                this.reconnectFuture = null;
            }
            this.connect();
        }
    }

    @Override
    public void disconnect(StompSessionHandler handler) {
        this.compositeStompSessionHandler.removeHandler(handler);
    }

    protected StompHeaders getConnectHeaders() {
        return this.connectHeaders;
    }

    public String toString() {
        return ObjectUtils.identityToString((Object)this) + " {connecting=" + this.connecting + ", connected=" + this.connected + ", name='" + this.name + "'}";
    }

    protected abstract CompletableFuture<StompSession> doConnect(StompSessionHandler var1);

    private class CompositeStompSessionHandler
    extends StompSessionHandlerAdapter {
        private final List<StompSessionHandler> delegates = Collections.synchronizedList(new ArrayList());
        private final Lock delegatesMonitor = new ReentrantLock();
        private volatile StompSession session;

        CompositeStompSessionHandler() {
        }

        void addHandler(StompSessionHandler delegate) {
            this.delegatesMonitor.lock();
            try {
                if (this.session != null) {
                    delegate.afterConnected(this.session, AbstractStompSessionManager.this.getConnectHeaders());
                }
                this.delegates.add(delegate);
            }
            finally {
                this.delegatesMonitor.unlock();
            }
        }

        void removeHandler(StompSessionHandler delegate) {
            this.delegates.remove(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterConnected(StompSession session, StompHeaders connectedHeaders) {
            this.delegatesMonitor.lock();
            try {
                this.session = session;
                for (StompSessionHandler delegate : this.delegates) {
                    delegate.afterConnected(session, connectedHeaders);
                }
            }
            finally {
                this.delegatesMonitor.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleException(StompSession session, @Nullable StompCommand command, StompHeaders headers, byte[] payload, Throwable exception) {
            this.delegatesMonitor.lock();
            try {
                for (StompSessionHandler delegate : this.delegates) {
                    delegate.handleException(session, command, headers, payload, exception);
                }
            }
            finally {
                this.delegatesMonitor.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleTransportError(StompSession session, Throwable exception) {
            AbstractStompSessionManager.this.logger.error((Object)("STOMP transport error for session: [" + String.valueOf(session) + "]"), exception);
            this.session = null;
            AbstractStompSessionManager.this.scheduleReconnect(exception);
            this.delegatesMonitor.lock();
            try {
                for (StompSessionHandler delegate : this.delegates) {
                    delegate.handleTransportError(session, exception);
                }
            }
            finally {
                this.delegatesMonitor.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleFrame(StompHeaders headers, Object payload) {
            this.delegatesMonitor.lock();
            try {
                for (StompSessionHandler delegate : this.delegates) {
                    delegate.handleFrame(headers, payload);
                }
            }
            finally {
                this.delegatesMonitor.unlock();
            }
        }
    }
}

