/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.stream;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.springframework.integration.core.MessagingException;
import org.springframework.integration.message.MessageSource;
import org.springframework.integration.message.StringMessage;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterStreamReadingMessageSource
implements MessageSource<String> {
    private final BufferedReader reader;
    private final Object monitor;

    public CharacterStreamReadingMessageSource(Reader reader) {
        this(reader, -1);
    }

    public CharacterStreamReadingMessageSource(Reader reader, int bufferSize) {
        Assert.notNull((Object)reader, (String)"reader must not be null");
        this.monitor = reader;
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : (bufferSize > 0 ? new BufferedReader(reader, bufferSize) : new BufferedReader(reader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StringMessage receive() {
        try {
            Object object = this.monitor;
            synchronized (object) {
                if (!this.reader.ready()) {
                    return null;
                }
                String line = this.reader.readLine();
                if (line == null) return null;
                StringMessage stringMessage = new StringMessage(line);
                return stringMessage;
            }
        }
        catch (IOException e) {
            throw new MessagingException("IO failure occurred in adapter", (Throwable)e);
        }
    }

    public static final CharacterStreamReadingMessageSource stdin() {
        return new CharacterStreamReadingMessageSource(new InputStreamReader(System.in));
    }

    public static final CharacterStreamReadingMessageSource stdin(String charsetName) {
        try {
            return new CharacterStreamReadingMessageSource(new InputStreamReader(System.in, charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("unsupported encoding: " + charsetName, e);
        }
    }
}

