/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.context;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.Lifecycle;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.endpoint.IntegrationConsumer;
import org.springframework.integration.endpoint.SourcePollingChannelAdapter;
import org.springframework.integration.test.mock.MockMessageHandler;
import org.springframework.integration.test.util.TestUtils;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class MockIntegrationContext
implements BeanFactoryAware {
    public static final String MOCK_INTEGRATION_CONTEXT_BEAN_NAME = "mockIntegrationContext";
    private final Map<String, Object> beans = new HashMap<String, Object>();
    private ConfigurableListableBeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isAssignable(ConfigurableListableBeanFactory.class, beanFactory.getClass(), (String)"a ConfigurableListableBeanFactory is required");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void resetBeans(String ... beanNames) {
        List<String> names = !ObjectUtils.isEmpty((Object[])beanNames) ? Arrays.asList(beanNames) : null;
        this.beans.entrySet().stream().filter(e -> names == null || names.contains(e.getKey())).forEach(e -> {
            Object endpoint = this.beanFactory.getBean((String)e.getKey());
            DirectFieldAccessor directFieldAccessor = new DirectFieldAccessor(endpoint);
            if (endpoint instanceof SourcePollingChannelAdapter) {
                directFieldAccessor.setPropertyValue("source", e.getValue());
            } else if (endpoint instanceof IntegrationConsumer) {
                directFieldAccessor.setPropertyValue("handler", e.getValue());
            }
        });
    }

    public void substituteMessageSourceFor(String pollingAdapterId, MessageSource<?> mockMessageSource) {
        this.substituteMessageSourceFor(pollingAdapterId, mockMessageSource, true);
    }

    public void substituteMessageSourceFor(String pollingAdapterId, MessageSource<?> mockMessageSource, boolean autoStartup) {
        this.substituteMessageSourceFor(pollingAdapterId, mockMessageSource, SourcePollingChannelAdapter.class, "source", autoStartup);
    }

    public void substituteMessageHandlerFor(String consumerEndpointId, MessageHandler mockMessageHandler) {
        this.substituteMessageHandlerFor(consumerEndpointId, mockMessageHandler, true);
    }

    public void substituteMessageHandlerFor(String consumerEndpointId, MessageHandler mockMessageHandler, boolean autoStartup) {
        Object endpoint = this.beanFactory.getBean(consumerEndpointId, IntegrationConsumer.class);
        if (autoStartup && endpoint instanceof Lifecycle) {
            ((Lifecycle)endpoint).stop();
        }
        DirectFieldAccessor directFieldAccessor = new DirectFieldAccessor(endpoint);
        Object targetMessageHandler = directFieldAccessor.getPropertyValue("handler");
        this.beans.put(consumerEndpointId, targetMessageHandler);
        if (mockMessageHandler instanceof MessageProducer) {
            if (targetMessageHandler instanceof MessageProducer) {
                MessageChannel outputChannel = ((MessageProducer)targetMessageHandler).getOutputChannel();
                ((MessageProducer)mockMessageHandler).setOutputChannel(outputChannel);
            } else if (mockMessageHandler instanceof MockMessageHandler) {
                if (((Boolean)TestUtils.getPropertyValue((Object)mockMessageHandler, (String)"hasReplies", Boolean.class)).booleanValue()) {
                    throw new IllegalStateException("The [" + mockMessageHandler + "] with replies can't replace simple MessageHandler [" + targetMessageHandler + "]");
                }
            } else {
                throw new IllegalStateException("The MessageProducer handler [" + mockMessageHandler + "] can't replace simple MessageHandler [" + targetMessageHandler + "]");
            }
        }
        directFieldAccessor.setPropertyValue("handler", (Object)mockMessageHandler);
        if (autoStartup && endpoint instanceof Lifecycle) {
            ((Lifecycle)endpoint).start();
        }
    }

    private void substituteMessageSourceFor(String endpointId, Object messagingComponent, Class<?> endpointClass, String property, boolean autoStartup) {
        Object endpoint = this.beanFactory.getBean(endpointId, endpointClass);
        if (autoStartup && endpoint instanceof Lifecycle) {
            ((Lifecycle)endpoint).stop();
        }
        DirectFieldAccessor directFieldAccessor = new DirectFieldAccessor(endpoint);
        this.beans.put(endpointId, directFieldAccessor.getPropertyValue(property));
        directFieldAccessor.setPropertyValue(property, messagingComponent);
        if (autoStartup && endpoint instanceof Lifecycle) {
            ((Lifecycle)endpoint).start();
        }
    }
}

