/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.twitter.outbound;

import org.springframework.integration.Message;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.social.twitter.api.Tweet;
import org.springframework.social.twitter.api.Twitter;
import org.springframework.util.Assert;

public class StatusUpdatingMessageHandler
extends AbstractMessageHandler {
    private final Twitter twitter;

    public StatusUpdatingMessageHandler(Twitter twitter) {
        Assert.notNull((Object)twitter, (String)"twitter must not be null");
        this.twitter = twitter;
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        Object payload = message.getPayload();
        String statusText = null;
        if (payload instanceof Tweet) {
            statusText = ((Tweet)payload).getText();
        } else if (payload instanceof String) {
            statusText = (String)payload;
        } else {
            throw new MessageHandlingException(message, "Unsupported payload type '" + payload.getClass().getName() + "'");
        }
        this.twitter.timelineOperations().updateStatus(statusText);
    }
}

