/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.twitter.inbound;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.metadata.MetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.social.twitter.api.DirectMessage;
import org.springframework.social.twitter.api.Tweet;
import org.springframework.social.twitter.api.Twitter;
import org.springframework.social.twitter.api.UserOperations;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

abstract class AbstractTwitterMessageSource<T>
extends IntegrationObjectSupport
implements MessageSource {
    private static final int DEFAULT_PAGE_SIZE = 20;
    private final Twitter twitter;
    private final TweetComparator tweetComparator = new TweetComparator();
    private final Object lastEnqueuedIdMonitor = new Object();
    private final String metadataKey;
    private volatile MetadataStore metadataStore;
    private final Queue<T> tweets = new LinkedBlockingQueue<T>();
    private volatile int prefetchThreshold = 0;
    private volatile long lastEnqueuedId = -1L;
    private volatile long lastProcessedId = -1L;
    private volatile int pageSize = 20;

    public AbstractTwitterMessageSource(Twitter twitter, String metadataKey) {
        UserOperations userOperations;
        String profileId;
        Assert.notNull((Object)twitter, (String)"twitter must not be null");
        Assert.notNull((Object)metadataKey, (String)"metadataKey must not be null");
        this.twitter = twitter;
        if (this.twitter.isAuthorized() && (profileId = String.valueOf((userOperations = this.twitter.userOperations()).getProfileId())) != null) {
            metadataKey = metadataKey + "." + profileId;
        }
        this.metadataKey = metadataKey;
    }

    public void setMetadataStore(MetadataStore metadataStore) {
        this.metadataStore = metadataStore;
    }

    public void setPrefetchThreshold(int prefetchThreshold) {
        this.prefetchThreshold = prefetchThreshold;
    }

    protected Twitter getTwitter() {
        return this.twitter;
    }

    protected int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    protected void onInit() throws Exception {
        String lastId;
        super.onInit();
        if (this.metadataStore == null) {
            BeanFactory beanFactory = this.getBeanFactory();
            if (beanFactory != null) {
                this.metadataStore = IntegrationContextUtils.getMetadataStore((BeanFactory)beanFactory);
            }
            if (this.metadataStore == null) {
                this.metadataStore = new SimpleMetadataStore();
            }
        }
        if (StringUtils.hasText((String)(lastId = this.metadataStore.get(this.metadataKey)))) {
            this.lastEnqueuedId = this.lastProcessedId = Long.parseLong(lastId);
        }
    }

    public Message<?> receive() {
        T tweet = this.tweets.poll();
        if (tweet == null) {
            this.refreshTweetQueueIfNecessary();
            tweet = this.tweets.poll();
        }
        if (tweet != null) {
            this.lastProcessedId = this.getIdForTweet(tweet);
            this.metadataStore.put(this.metadataKey, String.valueOf(this.lastProcessedId));
            return this.getMessageBuilderFactory().withPayload(tweet).build();
        }
        return null;
    }

    private void enqueueAll(List<T> tweets) {
        Collections.sort(tweets, this.tweetComparator);
        for (T tweet : tweets) {
            this.enqueue(tweet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(T tweet) {
        Object object = this.lastEnqueuedIdMonitor;
        synchronized (object) {
            long id = this.getIdForTweet(tweet);
            if (id > this.lastEnqueuedId) {
                this.tweets.add(tweet);
                this.lastEnqueuedId = id;
            }
        }
    }

    private void refreshTweetQueueIfNecessary() {
        try {
            List<T> tweets;
            if (this.tweets.size() <= this.prefetchThreshold && !CollectionUtils.isEmpty(tweets = this.pollForTweets(this.lastEnqueuedId))) {
                this.enqueueAll(tweets);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagingException("failed while polling Twitter", (Throwable)e);
        }
    }

    protected abstract List<T> pollForTweets(long var1);

    private long getIdForTweet(T twitterMessage) {
        if (twitterMessage instanceof Tweet) {
            return ((Tweet)twitterMessage).getId();
        }
        if (twitterMessage instanceof DirectMessage) {
            return ((DirectMessage)twitterMessage).getId();
        }
        throw new IllegalArgumentException("Unsupported Twitter object: " + twitterMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Remove the metadata key and the corresponding value from the Metadata Store.")
    void resetMetadataStore() {
        AbstractTwitterMessageSource abstractTwitterMessageSource = this;
        synchronized (abstractTwitterMessageSource) {
            this.metadataStore.remove(this.metadataKey);
            this.lastProcessedId = -1L;
            this.lastEnqueuedId = -1L;
        }
    }

    @ManagedAttribute
    public long getLastProcessedId() {
        return this.lastProcessedId;
    }

    private class TweetComparator
    implements Comparator<T> {
        private TweetComparator() {
        }

        @Override
        public int compare(T tweet1, T tweet2) {
            if (tweet1 instanceof Tweet && tweet2 instanceof Tweet) {
                Tweet t1 = (Tweet)tweet1;
                Tweet t2 = (Tweet)tweet2;
                Date t1CreatedAt = t1.getCreatedAt();
                Date t2CreatedAt = t2.getCreatedAt();
                Assert.notNull((Object)t1CreatedAt, (String)"Tweet is missing 'createdAt' date. Cannot compare.");
                Assert.notNull((Object)t2CreatedAt, (String)"Tweet is missing 'createdAt' date. Cannot compare.");
                return t1CreatedAt.compareTo(t2CreatedAt);
            }
            if (tweet1 instanceof DirectMessage && tweet2 instanceof DirectMessage) {
                DirectMessage d1 = (DirectMessage)tweet1;
                DirectMessage d2 = (DirectMessage)tweet2;
                Date d1CreatedAt = d1.getCreatedAt();
                Date d2CreatedAt = d2.getCreatedAt();
                Assert.notNull((Object)d1CreatedAt, (String)"DirectMessage is missing 'createdAt' date. Cannot compare.");
                Assert.notNull((Object)d2CreatedAt, (String)"DirectMessage is missing 'createdAt' date. Cannot compare.");
                return d1CreatedAt.compareTo(d2CreatedAt);
            }
            throw new IllegalArgumentException("Uncomparable Twitter objects: " + tweet1 + " and " + tweet2);
        }
    }
}

