/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.webflux.inbound;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.integration.expression.ExpressionEvalMap;
import org.springframework.integration.http.inbound.BaseHttpInboundEndpoint;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.accept.HeaderContentTypeResolver;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;
import org.springframework.web.server.WebHandler;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;
import reactor.util.function.Tuple2;

public class WebFluxInboundEndpoint
extends BaseHttpInboundEndpoint
implements WebHandler {
    private static final MediaType MEDIA_TYPE_APPLICATION_ALL = new MediaType("application");
    private static final List<HttpMethod> SAFE_METHODS = Arrays.asList(HttpMethod.GET, HttpMethod.HEAD);
    private ServerCodecConfigurer codecConfigurer = ServerCodecConfigurer.create();
    private RequestedContentTypeResolver requestedContentTypeResolver = new HeaderContentTypeResolver();
    private ReactiveAdapterRegistry adapterRegistry = new ReactiveAdapterRegistry();

    public WebFluxInboundEndpoint() {
        this(true);
    }

    public WebFluxInboundEndpoint(boolean expectReply) {
        super(expectReply);
    }

    public void setCodecConfigurer(ServerCodecConfigurer codecConfigurer) {
        Assert.notNull((Object)codecConfigurer, (String)"'codecConfigurer' must not be null");
        this.codecConfigurer = codecConfigurer;
    }

    public void setRequestedContentTypeResolver(RequestedContentTypeResolver requestedContentTypeResolver) {
        Assert.notNull((Object)requestedContentTypeResolver, (String)"'requestedContentTypeResolver' must not be null");
        this.requestedContentTypeResolver = requestedContentTypeResolver;
    }

    public void setReactiveAdapterRegistry(ReactiveAdapterRegistry adapterRegistry) {
        Assert.notNull((Object)adapterRegistry, (String)"'adapterRegistry' must not be null");
        this.adapterRegistry = adapterRegistry;
    }

    public String getComponentType() {
        return super.getComponentType().replaceFirst("http", "webflux");
    }

    public Mono<Void> handle(ServerWebExchange exchange) {
        return Mono.deferContextual(context -> {
            if (this.isRunning()) {
                return this.doHandle(exchange, (ContextView)context);
            }
            return Mono.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, "Endpoint is stopped")).then();
        });
    }

    private Mono<Void> doHandle(ServerWebExchange exchange, ContextView context) {
        return this.extractRequestBody(exchange).doOnSubscribe(s -> this.activeCount.incrementAndGet()).map(body -> new RequestEntity(body, (MultiValueMap)exchange.getRequest().getHeaders(), exchange.getRequest().getMethod(), exchange.getRequest().getURI())).flatMap(entity -> this.buildMessage((RequestEntity<?>)entity, exchange, context)).flatMap(requestTuple -> {
            if (this.isExpectReply()) {
                return this.sendAndReceiveMessageReactive(requestTuple.getT1()).flatMap(replyMessage -> this.populateResponse(exchange, (Message<?>)replyMessage));
            }
            return Mono.just((Object)((Message)requestTuple.getT1())).handle((objectMessage, synchronousSink) -> {
                this.send(objectMessage);
                synchronousSink.complete();
            }).then(this.setStatusCode(exchange, (RequestEntity)requestTuple.getT2()));
        }).doOnTerminate(this.activeCount::decrementAndGet);
    }

    private Mono<?> extractRequestBody(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        if (WebFluxInboundEndpoint.isReadable((HttpMethod)request.getMethod())) {
            return this.extractReadableRequestBody(exchange).cast(Object.class).switchIfEmpty(WebFluxInboundEndpoint.queryParams(request));
        }
        return WebFluxInboundEndpoint.queryParams(request);
    }

    private Mono<?> extractReadableRequestBody(ServerWebExchange exchange) {
        MediaType contentType = exchange.getRequest().getHeaders().getContentType();
        if (contentType == null) {
            contentType = MediaType.APPLICATION_OCTET_STREAM;
        }
        if (MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(contentType)) {
            return exchange.getFormData();
        }
        if (MediaType.MULTIPART_FORM_DATA.isCompatibleWith(contentType)) {
            return exchange.getMultipartData();
        }
        return this.readRequestBody(exchange, contentType);
    }

    private Mono<?> readRequestBody(ServerWebExchange exchange, MediaType contentType) {
        Class resolvedType;
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        ResolvableType bodyType = this.getRequestPayloadType();
        if (bodyType == null) {
            bodyType = "text".equals(contentType.getType()) ? ResolvableType.forClass(String.class) : ResolvableType.forClass(byte[].class);
        }
        ReactiveAdapter adapter = (resolvedType = bodyType.resolve()) != null ? this.adapterRegistry.getAdapter(resolvedType) : null;
        ResolvableType elementType = adapter != null ? bodyType.getGeneric(new int[0]) : bodyType;
        HttpMessageReader httpMessageReader = this.codecConfigurer.getReaders().stream().filter(reader -> reader.canRead(elementType, contentType)).findFirst().orElseThrow(() -> new UnsupportedMediaTypeStatusException("Could not convert request: no suitable HttpMessageReader found for expected type [" + String.valueOf(elementType) + "] and content type [" + String.valueOf(contentType) + "]"));
        Map readHints = Collections.emptyMap();
        if (adapter != null && adapter.isMultiValue()) {
            Flux flux = httpMessageReader.read(bodyType, elementType, request, response, readHints);
            if (this.getValidator() != null) {
                flux = flux.doOnNext(x$0 -> this.validate(x$0));
            }
            return Mono.just((Object)adapter.fromPublisher((Publisher)flux));
        }
        Mono mono = httpMessageReader.readMono(bodyType, elementType, request, response, readHints);
        if (this.getValidator() != null) {
            mono = mono.doOnNext(x$0 -> this.validate(x$0));
        }
        if (adapter != null) {
            return Mono.just((Object)adapter.fromPublisher((Publisher)mono));
        }
        return mono;
    }

    private Mono<Tuple2<Message<Object>, RequestEntity<?>>> buildMessage(RequestEntity<?> httpEntity, ServerWebExchange exchange, ContextView context) {
        ServerHttpRequest request = exchange.getRequest();
        MultiValueMap requestParams = request.getQueryParams();
        EvaluationContext evaluationContext = this.buildEvaluationContext(httpEntity, exchange);
        Object payload = this.getPayloadExpression() != null ? this.getPayloadExpression().getValue(evaluationContext) : httpEntity.getBody();
        Map headers = this.getHeaderMapper().toHeaders((Object)request.getHeaders());
        if (!CollectionUtils.isEmpty((Map)this.getHeaderExpressions())) {
            headers.putAll(ExpressionEvalMap.from((Map)this.getHeaderExpressions()).usingEvaluationContext(evaluationContext).withRoot(httpEntity).build());
        }
        if (payload == null) {
            payload = requestParams;
        }
        AbstractIntegrationMessageBuilder<Object> messageBuilder = this.prepareRequestMessageBuilder(request, payload, headers);
        if (!context.isEmpty()) {
            messageBuilder.setHeader("reactorContext", (Object)context);
        }
        return exchange.getPrincipal().map(principal -> messageBuilder.setHeader("http_userPrincipal", principal)).defaultIfEmpty(messageBuilder).map(AbstractIntegrationMessageBuilder::build).zipWith(Mono.just(httpEntity));
    }

    private AbstractIntegrationMessageBuilder<Object> prepareRequestMessageBuilder(ServerHttpRequest request, Object payload, Map<String, Object> headers) {
        AbstractIntegrationMessageBuilder messageBuilder = payload instanceof Message ? this.getMessageBuilderFactory().fromMessage((Message)payload).copyHeadersIfAbsent(headers) : this.getMessageBuilderFactory().withPayload(payload).copyHeaders(headers);
        messageBuilder.setHeader("http_requestUrl", (Object)request.getURI().toString());
        HttpMethod httpMethod = request.getMethod();
        if (httpMethod != null) {
            messageBuilder.setHeader("http_requestMethod", (Object)httpMethod.toString());
        }
        return messageBuilder;
    }

    private EvaluationContext buildEvaluationContext(RequestEntity<?> httpEntity, ServerWebExchange exchange) {
        Map matrixVariables;
        Map pathVariables;
        ServerHttpRequest request = exchange.getRequest();
        HttpHeaders requestHeaders = request.getHeaders();
        MultiValueMap requestParams = request.getQueryParams();
        Map exchangeAttributes = exchange.getAttributes();
        StandardEvaluationContext evaluationContext = this.createEvaluationContext();
        evaluationContext.setVariable("requestAttributes", (Object)exchangeAttributes);
        evaluationContext.setVariable("requestParams", (Object)requestParams);
        evaluationContext.setVariable("requestHeaders", (Object)requestHeaders);
        if (!CollectionUtils.isEmpty((Map)request.getCookies())) {
            evaluationContext.setVariable("cookies", (Object)request.getCookies());
        }
        if (!CollectionUtils.isEmpty((Map)(pathVariables = (Map)exchangeAttributes.get(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE)))) {
            evaluationContext.setVariable("pathVariables", (Object)pathVariables);
        }
        if (!CollectionUtils.isEmpty((Map)(matrixVariables = (Map)exchangeAttributes.get(HandlerMapping.MATRIX_VARIABLES_ATTRIBUTE)))) {
            evaluationContext.setVariable("matrixVariables", (Object)matrixVariables);
        }
        evaluationContext.setRootObject(httpEntity);
        return evaluationContext;
    }

    private Mono<Void> populateResponse(ServerWebExchange exchange, Message<?> replyMessage) {
        ServerHttpResponse response = exchange.getResponse();
        this.getHeaderMapper().fromHeaders(replyMessage.getHeaders(), (Object)response.getHeaders());
        Object responseContent = replyMessage;
        if (this.getExtractReplyPayload()) {
            responseContent = replyMessage.getPayload();
        }
        if (responseContent instanceof HttpStatus) {
            HttpStatus httpStatus = (HttpStatus)responseContent;
            response.setStatusCode((HttpStatusCode)httpStatus);
            return response.setComplete();
        }
        HttpStatus httpStatus = this.resolveHttpStatusFromHeaders(replyMessage.getHeaders());
        if (httpStatus != null) {
            response.setStatusCode((HttpStatusCode)httpStatus);
        }
        if (responseContent instanceof ResponseEntity) {
            return Mono.just((Object)((ResponseEntity)responseContent)).flatMap(e -> {
                if (httpStatus == null) {
                    exchange.getResponse().setStatusCode(e.getStatusCode());
                }
                HttpHeaders entityHeaders = e.getHeaders();
                HttpHeaders responseHeaders = exchange.getResponse().getHeaders();
                if (!entityHeaders.isEmpty()) {
                    entityHeaders.entrySet().stream().filter(entry -> !responseHeaders.containsKey(entry.getKey())).forEach(entry -> responseHeaders.put((String)entry.getKey(), (List)entry.getValue()));
                }
                if (e.getBody() == null) {
                    return exchange.getResponse().setComplete();
                }
                String etag = entityHeaders.getETag();
                Instant lastModified = Instant.ofEpochMilli(entityHeaders.getLastModified());
                HttpMethod httpMethod = exchange.getRequest().getMethod();
                if (SAFE_METHODS.contains(httpMethod) && exchange.checkNotModified(etag, lastModified)) {
                    return exchange.getResponse().setComplete();
                }
                return this.writeResponseBody(exchange, e.getBody());
            });
        }
        return this.writeResponseBody(exchange, responseContent);
    }

    private Mono<Void> writeResponseBody(ServerWebExchange exchange, Object body) {
        ResolvableType elementType;
        Mono publisher;
        ResolvableType bodyType = ResolvableType.forInstance((Object)body);
        ReactiveAdapter adapter = this.adapterRegistry.getAdapter(bodyType.resolve(), body);
        if (adapter != null) {
            publisher = adapter.toPublisher(body);
            ResolvableType genericType = bodyType.getGeneric(new int[]{0});
            elementType = WebFluxInboundEndpoint.getElementType(adapter, genericType);
        } else {
            publisher = Mono.justOrEmpty((Object)body);
            elementType = bodyType;
        }
        if (Void.TYPE == elementType.getRawClass() || Void.class == elementType.getRawClass()) {
            return Mono.from((Publisher)publisher);
        }
        List<MediaType> producibleMediaTypes = this.getProducibleMediaTypes(bodyType);
        MediaType bestMediaType = this.selectMediaType(exchange, () -> producibleMediaTypes);
        if (bestMediaType != null) {
            for (HttpMessageWriter writer : this.codecConfigurer.getWriters()) {
                if (!writer.canWrite(bodyType, bestMediaType)) continue;
                return writer.write((Publisher)publisher, elementType, bestMediaType, (ReactiveHttpOutputMessage)exchange.getResponse(), Collections.emptyMap());
            }
        } else if (producibleMediaTypes.isEmpty()) {
            return Mono.error((Throwable)new IllegalStateException("No HttpMessageWriters for response type: " + String.valueOf(bodyType)));
        }
        return Mono.error((Throwable)new NotAcceptableStatusException(producibleMediaTypes));
    }

    private List<MediaType> getProducibleMediaTypes(ResolvableType elementType) {
        return this.codecConfigurer.getWriters().stream().filter(converter -> converter.canWrite(elementType, null)).flatMap(converter -> converter.getWritableMediaTypes().stream()).collect(Collectors.toList());
    }

    private MediaType selectMediaType(ServerWebExchange exchange, Supplier<List<MediaType>> producibleTypesSupplier) {
        List<MediaType> acceptableTypes = this.getAcceptableTypes(exchange);
        List<MediaType> producibleTypes = WebFluxInboundEndpoint.getProducibleTypes(exchange, producibleTypesSupplier);
        LinkedHashSet<MediaType> compatibleMediaTypes = new LinkedHashSet<MediaType>();
        for (MediaType acceptable : acceptableTypes) {
            for (MediaType producible : producibleTypes) {
                if (!acceptable.isCompatibleWith(producible)) continue;
                compatibleMediaTypes.add(WebFluxInboundEndpoint.selectMoreSpecificMediaType(acceptable, producible));
            }
        }
        ArrayList result = new ArrayList(compatibleMediaTypes);
        MimeTypeUtils.sortBySpecificity(result);
        for (MediaType mediaType : result) {
            if (mediaType.isConcrete()) {
                return mediaType;
            }
            if (!mediaType.equals((Object)MediaType.ALL) && !mediaType.equals((Object)MEDIA_TYPE_APPLICATION_ALL)) continue;
            return MediaType.APPLICATION_OCTET_STREAM;
        }
        return null;
    }

    private List<MediaType> getAcceptableTypes(ServerWebExchange exchange) {
        List<MediaType> mediaTypes = this.requestedContentTypeResolver.resolveMediaTypes(exchange);
        return mediaTypes.isEmpty() ? Collections.singletonList(MediaType.ALL) : mediaTypes;
    }

    private Mono<Void> setStatusCode(ServerWebExchange exchange, RequestEntity<?> requestEntity) {
        HttpStatus httpStatus;
        ServerHttpResponse response = exchange.getResponse();
        if (this.getStatusCodeExpression() != null && (httpStatus = this.evaluateHttpStatus((HttpEntity)requestEntity)) != null) {
            response.setStatusCode((HttpStatusCode)httpStatus);
        }
        return response.setComplete();
    }

    private static ResolvableType getElementType(ReactiveAdapter adapter, ResolvableType genericType) {
        if (adapter.isNoValue()) {
            return ResolvableType.forClass(Void.class);
        }
        if (!ResolvableType.NONE.equals((Object)genericType)) {
            return genericType;
        }
        return ResolvableType.forClass(Object.class);
    }

    private static List<MediaType> getProducibleTypes(ServerWebExchange exchange, Supplier<List<MediaType>> producibleTypesSupplier) {
        Set mediaTypes = (Set)exchange.getAttribute(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
        return mediaTypes != null ? new ArrayList(mediaTypes) : producibleTypesSupplier.get();
    }

    private static Mono<?> queryParams(ServerHttpRequest request) {
        return Mono.just((Object)request.getQueryParams());
    }

    private static MediaType selectMoreSpecificMediaType(MediaType acceptable, MediaType producible) {
        MediaType producibleToUse = producible.copyQualityValue(acceptable);
        if (acceptable.isLessSpecific((MimeType)producibleToUse)) {
            return producibleToUse;
        }
        return acceptable;
    }
}

