/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.websocket;

import java.util.Arrays;
import org.springframework.context.Lifecycle;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.JavaUtils;
import org.springframework.integration.websocket.IntegrationWebSocketContainer;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.SockJsServiceRegistration;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistration;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.handler.WebSocketHandlerDecoratorFactory;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.socket.sockjs.frame.SockJsMessageCodec;
import org.springframework.web.socket.sockjs.transport.TransportHandler;

public class ServerWebSocketContainer
extends IntegrationWebSocketContainer
implements WebSocketConfigurer,
SmartLifecycle {
    private final String[] paths;
    private HandshakeHandler handshakeHandler;
    private HandshakeInterceptor[] interceptors;
    private WebSocketHandlerDecoratorFactory[] decoratorFactories;
    private SockJsServiceOptions sockJsServiceOptions;
    private String[] origins;
    private boolean autoStartup = true;
    private int phase = 0;
    private TaskScheduler sockJsTaskScheduler;

    public ServerWebSocketContainer(String ... paths) {
        Assert.notEmpty((Object[])paths, (String)"'paths' must not be empty");
        this.paths = Arrays.copyOf(paths, paths.length);
    }

    public ServerWebSocketContainer setHandshakeHandler(HandshakeHandler handshakeHandler) {
        this.handshakeHandler = handshakeHandler;
        return this;
    }

    public ServerWebSocketContainer setInterceptors(HandshakeInterceptor ... interceptors) {
        Assert.notNull((Object)interceptors, (String)"'interceptors' must not be null");
        Assert.noNullElements((Object[])interceptors, (String)"'interceptors' must not contain null elements");
        this.interceptors = Arrays.copyOf(interceptors, interceptors.length);
        return this;
    }

    public ServerWebSocketContainer setDecoratorFactories(WebSocketHandlerDecoratorFactory ... factories) {
        Assert.notNull((Object)factories, (String)"'factories' must not be null");
        Assert.noNullElements((Object[])factories, (String)"'factories' must not contain null elements");
        this.decoratorFactories = Arrays.copyOf(factories, factories.length);
        return this;
    }

    public ServerWebSocketContainer setAllowedOrigins(String ... origins) {
        Assert.notEmpty((Object[])origins, (String)"'origins' must not be empty");
        this.origins = Arrays.copyOf(origins, origins.length);
        return this;
    }

    public ServerWebSocketContainer withSockJs(SockJsServiceOptions ... sockJsServiceOptions) {
        if (ObjectUtils.isEmpty((Object[])sockJsServiceOptions)) {
            this.setSockJsServiceOptions(new SockJsServiceOptions());
        } else {
            Assert.state((sockJsServiceOptions.length == 1 ? 1 : 0) != 0, (String)"Only one 'sockJsServiceOptions' is applicable.");
            this.setSockJsServiceOptions(sockJsServiceOptions[0]);
        }
        return this;
    }

    public void setSockJsServiceOptions(SockJsServiceOptions sockJsServiceOptions) {
        this.sockJsServiceOptions = sockJsServiceOptions;
    }

    public void setSockJsTaskScheduler(TaskScheduler sockJsTaskScheduler) {
        this.sockJsTaskScheduler = sockJsTaskScheduler;
    }

    public TaskScheduler getSockJsTaskScheduler() {
        return this.sockJsTaskScheduler;
    }

    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        WebSocketHandler webSocketHandler = this.webSocketHandler;
        if (this.decoratorFactories != null) {
            for (WebSocketHandlerDecoratorFactory factory : this.decoratorFactories) {
                webSocketHandler = factory.decorate(webSocketHandler);
            }
        }
        WebSocketHandlerRegistration registration = registry.addHandler(webSocketHandler, this.paths).setHandshakeHandler(this.handshakeHandler).addInterceptors(this.interceptors).setAllowedOrigins(this.origins);
        this.configureSockJsOptionsIfAny(registration);
    }

    private void configureSockJsOptionsIfAny(WebSocketHandlerRegistration registration) {
        if (this.sockJsServiceOptions != null) {
            SockJsServiceRegistration sockJsServiceRegistration = registration.withSockJS();
            JavaUtils.INSTANCE.acceptIfCondition(this.sockJsServiceOptions.taskScheduler == null, (Object)this.sockJsTaskScheduler, this.sockJsServiceOptions::setTaskScheduler).acceptIfNotNull((Object)this.sockJsServiceOptions.webSocketEnabled, arg_0 -> ((SockJsServiceRegistration)sockJsServiceRegistration).setWebSocketEnabled(arg_0)).acceptIfNotNull((Object)this.sockJsServiceOptions.clientLibraryUrl, arg_0 -> ((SockJsServiceRegistration)sockJsServiceRegistration).setClientLibraryUrl(arg_0)).acceptIfNotNull((Object)this.sockJsServiceOptions.disconnectDelay, arg_0 -> ((SockJsServiceRegistration)sockJsServiceRegistration).setDisconnectDelay(arg_0)).acceptIfNotNull((Object)this.sockJsServiceOptions.heartbeatTime, arg_0 -> ((SockJsServiceRegistration)sockJsServiceRegistration).setHeartbeatTime(arg_0)).acceptIfNotNull((Object)this.sockJsServiceOptions.httpMessageCacheSize, arg_0 -> ((SockJsServiceRegistration)sockJsServiceRegistration).setHttpMessageCacheSize(arg_0)).acceptIfNotNull((Object)this.sockJsServiceOptions.heartbeatTime, arg_0 -> ((SockJsServiceRegistration)sockJsServiceRegistration).setHeartbeatTime(arg_0)).acceptIfNotNull((Object)this.sockJsServiceOptions.sessionCookieNeeded, arg_0 -> ((SockJsServiceRegistration)sockJsServiceRegistration).setSessionCookieNeeded(arg_0)).acceptIfNotNull((Object)this.sockJsServiceOptions.streamBytesLimit, arg_0 -> ((SockJsServiceRegistration)sockJsServiceRegistration).setStreamBytesLimit(arg_0)).acceptIfNotNull((Object)this.sockJsServiceOptions.transportHandlers, arg_0 -> ((SockJsServiceRegistration)sockJsServiceRegistration).setTransportHandlers(arg_0)).acceptIfNotNull((Object)this.sockJsServiceOptions.taskScheduler, arg_0 -> ((SockJsServiceRegistration)sockJsServiceRegistration).setTaskScheduler(arg_0)).acceptIfNotNull((Object)this.sockJsServiceOptions.messageCodec, arg_0 -> ((SockJsServiceRegistration)sockJsServiceRegistration).setMessageCodec(arg_0)).acceptIfNotNull((Object)this.sockJsServiceOptions.suppressCors, arg_0 -> ((SockJsServiceRegistration)sockJsServiceRegistration).setSuppressCors(arg_0));
        }
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public int getPhase() {
        return this.phase;
    }

    public boolean isRunning() {
        return this.handshakeHandler instanceof Lifecycle && ((Lifecycle)this.handshakeHandler).isRunning();
    }

    public synchronized void start() {
        if (this.handshakeHandler instanceof Lifecycle && !this.isRunning()) {
            ((Lifecycle)this.handshakeHandler).start();
        }
    }

    public void stop() {
        if (this.isRunning()) {
            ((Lifecycle)this.handshakeHandler).stop();
        }
    }

    public void stop(Runnable callback) {
        if (this.isRunning()) {
            ((Lifecycle)this.handshakeHandler).stop();
        }
        callback.run();
    }

    public static class SockJsServiceOptions {
        private TaskScheduler taskScheduler;
        private String clientLibraryUrl;
        private Integer streamBytesLimit;
        private Boolean sessionCookieNeeded;
        private Long heartbeatTime;
        private Long disconnectDelay;
        private Integer httpMessageCacheSize;
        private Boolean webSocketEnabled;
        private TransportHandler[] transportHandlers;
        private SockJsMessageCodec messageCodec;
        private Boolean suppressCors;

        public SockJsServiceOptions setTaskScheduler(TaskScheduler taskScheduler) {
            this.taskScheduler = taskScheduler;
            return this;
        }

        public SockJsServiceOptions setClientLibraryUrl(String clientLibraryUrl) {
            this.clientLibraryUrl = clientLibraryUrl;
            return this;
        }

        public SockJsServiceOptions setStreamBytesLimit(int streamBytesLimit) {
            this.streamBytesLimit = streamBytesLimit;
            return this;
        }

        public SockJsServiceOptions setSessionCookieNeeded(boolean sessionCookieNeeded) {
            this.sessionCookieNeeded = sessionCookieNeeded;
            return this;
        }

        public SockJsServiceOptions setHeartbeatTime(long heartbeatTime) {
            this.heartbeatTime = heartbeatTime;
            return this;
        }

        public SockJsServiceOptions setDisconnectDelay(long disconnectDelay) {
            this.disconnectDelay = disconnectDelay;
            return this;
        }

        public SockJsServiceOptions setHttpMessageCacheSize(int httpMessageCacheSize) {
            this.httpMessageCacheSize = httpMessageCacheSize;
            return this;
        }

        public SockJsServiceOptions setWebSocketEnabled(boolean webSocketEnabled) {
            this.webSocketEnabled = webSocketEnabled;
            return this;
        }

        public SockJsServiceOptions setTransportHandlers(TransportHandler ... transportHandlers) {
            Assert.notEmpty((Object[])transportHandlers, (String)"'transportHandlers' must not be empty");
            this.transportHandlers = Arrays.copyOf(transportHandlers, transportHandlers.length);
            return this;
        }

        public SockJsServiceOptions setMessageCodec(SockJsMessageCodec messageCodec) {
            this.messageCodec = messageCodec;
            return this;
        }

        public SockJsServiceOptions setSuppressCors(boolean suppressCors) {
            this.suppressCors = suppressCors;
            return this;
        }
    }
}

