/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.websocket;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.integration.websocket.WebSocketListener;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.SubProtocolCapable;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.ConcurrentWebSocketSessionDecorator;

public abstract class IntegrationWebSocketContainer
implements DisposableBean {
    public static final int DEFAULT_SEND_TIME_LIMIT = 10000;
    public static final int DEFAULT_SEND_BUFFER_SIZE = 524288;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final Lock lock = new ReentrantLock();
    private WebSocketHandler webSocketHandler = new IntegrationWebSocketHandler();
    protected final Map<String, WebSocketSession> sessions = new ConcurrentHashMap<String, WebSocketSession>();
    private final List<String> supportedProtocols = new ArrayList<String>();
    private WebSocketListener messageListener;
    private int sendTimeLimit = 10000;
    private int sendBufferSizeLimit = 524288;
    @Nullable
    private ConcurrentWebSocketSessionDecorator.OverflowStrategy sendBufferOverflowStrategy;

    public void setSendTimeLimit(int sendTimeLimit) {
        this.sendTimeLimit = sendTimeLimit;
    }

    public void setSendBufferSizeLimit(int sendBufferSizeLimit) {
        this.sendBufferSizeLimit = sendBufferSizeLimit;
    }

    public void setSendBufferOverflowStrategy(@Nullable ConcurrentWebSocketSessionDecorator.OverflowStrategy overflowStrategy) {
        this.sendBufferOverflowStrategy = overflowStrategy;
    }

    public void setMessageListener(WebSocketListener messageListener) {
        Assert.state((this.messageListener == null || this.messageListener.equals(messageListener) ? 1 : 0) != 0, (String)"'messageListener' is already configured");
        this.messageListener = messageListener;
    }

    public void setSupportedProtocols(String ... protocols) {
        this.supportedProtocols.clear();
        this.addSupportedProtocols(protocols);
    }

    public void addSupportedProtocols(String ... protocols) {
        for (String protocol : protocols) {
            this.supportedProtocols.add(protocol.toLowerCase(Locale.ROOT));
        }
    }

    protected void setWebSocketHandler(WebSocketHandler handler) {
        this.webSocketHandler = handler;
    }

    public WebSocketHandler getWebSocketHandler() {
        return this.webSocketHandler;
    }

    public List<String> getSubProtocols() {
        ArrayList<String> protocols = new ArrayList<String>();
        if (this.messageListener != null) {
            protocols.addAll(this.messageListener.getSubProtocols());
        }
        protocols.addAll(this.supportedProtocols);
        return Collections.unmodifiableList(protocols);
    }

    public Map<String, WebSocketSession> getSessions() {
        return Collections.unmodifiableMap(this.sessions);
    }

    public WebSocketSession getSession(String sessionId) {
        WebSocketSession session = this.sessions.get(sessionId);
        Assert.notNull((Object)session, () -> "Session not found for id '" + sessionId + "'");
        return session;
    }

    public void closeSession(WebSocketSession session, CloseStatus closeStatus) throws Exception {
        session.close(closeStatus);
        this.webSocketHandler.afterConnectionClosed(session, closeStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            for (WebSocketSession session : this.sessions.values()) {
                try {
                    session.close(CloseStatus.GOING_AWAY);
                }
                catch (Exception ex) {
                    this.logger.error((Object)("Failed to close session id '" + session.getId() + "': " + ex.getMessage()));
                }
            }
        }
        finally {
            this.sessions.clear();
        }
    }

    private WebSocketSession decorateSession(WebSocketSession sessionToDecorate) {
        if (this.sendBufferOverflowStrategy == null) {
            return new ConcurrentWebSocketSessionDecorator(sessionToDecorate, this.sendTimeLimit, this.sendBufferSizeLimit);
        }
        return new ConcurrentWebSocketSessionDecorator(sessionToDecorate, this.sendTimeLimit, this.sendBufferSizeLimit, this.sendBufferOverflowStrategy);
    }

    private class IntegrationWebSocketHandler
    implements WebSocketHandler,
    SubProtocolCapable {
        IntegrationWebSocketHandler() {
        }

        public List<String> getSubProtocols() {
            return IntegrationWebSocketContainer.this.getSubProtocols();
        }

        public void afterConnectionEstablished(WebSocketSession sessionToDecorate) throws Exception {
            WebSocketSession session = IntegrationWebSocketContainer.this.decorateSession(sessionToDecorate);
            IntegrationWebSocketContainer.this.sessions.put(session.getId(), session);
            if (IntegrationWebSocketContainer.this.logger.isDebugEnabled()) {
                IntegrationWebSocketContainer.this.logger.debug((Object)("Started WebSocket session = " + session.getId() + ", number of sessions = " + IntegrationWebSocketContainer.this.sessions.size()));
            }
            if (IntegrationWebSocketContainer.this.messageListener != null) {
                IntegrationWebSocketContainer.this.messageListener.afterSessionStarted(session);
            }
        }

        public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) throws Exception {
            WebSocketSession removed = IntegrationWebSocketContainer.this.sessions.remove(session.getId());
            if (removed != null && IntegrationWebSocketContainer.this.messageListener != null) {
                IntegrationWebSocketContainer.this.messageListener.afterSessionEnded(session, closeStatus);
            }
        }

        public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
            IntegrationWebSocketContainer.this.sessions.remove(session.getId());
            ReflectionUtils.rethrowException((Throwable)exception);
        }

        public void handleMessage(WebSocketSession session, WebSocketMessage<?> message) throws Exception {
            if (IntegrationWebSocketContainer.this.messageListener != null) {
                IntegrationWebSocketContainer.this.messageListener.onMessage(session, message);
            } else if (IntegrationWebSocketContainer.this.logger.isInfoEnabled()) {
                IntegrationWebSocketContainer.this.logger.info((Object)("This 'WebSocketHandlerContainer' isn't configured with 'WebSocketMessageListener'. Received messages are ignored. Current message is: " + message));
            }
        }

        public boolean supportsPartialMessages() {
            return false;
        }
    }
}

