/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws;

import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.springframework.expression.ExpressionException;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.ws.DefaultSoapHeaderMapper;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.MessageEndpoint;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.xml.transform.StringSource;
import org.springframework.xml.transform.TransformerObjectSupport;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleWebServiceInboundGateway
extends MessagingGatewaySupport
implements MessageEndpoint {
    private final TransformerSupportDelegate transformerSupportDelegate = new TransformerSupportDelegate();
    private volatile boolean extractPayload = true;
    private volatile HeaderMapper<SoapHeader> headerMapper = new DefaultSoapHeaderMapper();

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    public void setHeaderMapper(HeaderMapper<SoapHeader> headerMapper) {
        Assert.notNull(headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    public String getComponentType() {
        return "ws:outbound-gateway";
    }

    public void invoke(MessageContext messageContext) throws Exception {
        try {
            this.doInvoke(messageContext);
        }
        catch (Exception e) {
            while ((e instanceof MessagingException || e instanceof ExpressionException) && e.getCause() instanceof Exception) {
                e = (Exception)e.getCause();
            }
            throw e;
        }
    }

    private void doInvoke(MessageContext messageContext) throws Exception {
        Message replyMessage;
        SoapMessage soapMessage;
        Map headers;
        Assert.notNull((Object)messageContext, (String)"'messageContext' is required; it must not be null.");
        WebServiceMessage request = messageContext.getRequest();
        Assert.notNull((Object)request, (String)"Invalid message context: request was null.");
        MessageBuilder builder = MessageBuilder.withPayload((Object)(this.extractPayload ? request.getPayloadSource() : request));
        String[] propertyNames = messageContext.getPropertyNames();
        if (propertyNames != null) {
            for (String propertyName : propertyNames) {
                builder.setHeader(propertyName, messageContext.getProperty(propertyName));
            }
        }
        if (request instanceof SoapMessage && !CollectionUtils.isEmpty((Map)(headers = this.headerMapper.toHeaders((Object)(soapMessage = (SoapMessage)request).getSoapHeader())))) {
            builder.copyHeaders(headers);
        }
        if ((replyMessage = this.sendAndReceiveMessage(builder.build())) != null && replyMessage.getPayload() != null) {
            Object replyPayload = replyMessage.getPayload();
            Source responseSource = null;
            if (replyPayload instanceof Source) {
                responseSource = (Source)replyPayload;
            } else if (replyPayload instanceof Document) {
                responseSource = new DOMSource((Document)replyPayload);
            } else if (replyPayload instanceof String) {
                responseSource = new StringSource((String)replyPayload);
            } else {
                throw new IllegalArgumentException("The reply Message payload must be a [" + Source.class.getName() + "], [" + Document.class.getName() + "], or [java.lang.String]. The actual type was [" + replyPayload.getClass().getName() + "]");
            }
            WebServiceMessage response = messageContext.getResponse();
            if (response instanceof SoapMessage) {
                this.headerMapper.fromHeaders(replyMessage.getHeaders(), (Object)((SoapMessage)response).getSoapHeader());
            }
            this.transformerSupportDelegate.transformSourceToResult(responseSource, response.getPayloadResult());
        }
    }

    private static class TransformerSupportDelegate
    extends TransformerObjectSupport {
        private TransformerSupportDelegate() {
        }

        void transformSourceToResult(Source source, Result result) throws TransformerException {
            this.transform(source, result);
        }
    }
}

