/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws;

import java.util.Map;
import org.springframework.expression.ExpressionException;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.ws.DefaultSoapHeaderMapper;
import org.springframework.integration.ws.SoapHeaderMapper;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.MessageEndpoint;
import org.springframework.ws.soap.SoapMessage;

public abstract class AbstractWebServiceInboundGateway
extends MessagingGatewaySupport
implements MessageEndpoint {
    protected volatile SoapHeaderMapper headerMapper = new DefaultSoapHeaderMapper();

    public String getComponentType() {
        return "ws:inbound-gateway";
    }

    public void setHeaderMapper(SoapHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    public void invoke(MessageContext messageContext) throws Exception {
        Assert.notNull((Object)messageContext, (String)"'messageContext' is required; it must not be null.");
        try {
            this.doInvoke(messageContext);
        }
        catch (Exception e) {
            while ((e instanceof MessagingException || e instanceof ExpressionException) && e.getCause() instanceof Exception) {
                e = (Exception)e.getCause();
            }
            throw e;
        }
    }

    protected void fromSoapHeaders(MessageContext messageContext, AbstractIntegrationMessageBuilder<?> builder) {
        SoapMessage soapMessage;
        Map headers;
        WebServiceMessage request = messageContext.getRequest();
        String[] propertyNames = messageContext.getPropertyNames();
        if (propertyNames != null) {
            for (String propertyName : propertyNames) {
                builder.setHeader(propertyName, messageContext.getProperty(propertyName));
            }
        }
        if (request instanceof SoapMessage && !CollectionUtils.isEmpty((Map)(headers = this.headerMapper.toHeadersFromRequest(soapMessage = (SoapMessage)request)))) {
            builder.copyHeaders(headers);
        }
    }

    protected void toSoapHeaders(WebServiceMessage response, Message<?> replyMessage) {
        if (response instanceof SoapMessage) {
            this.headerMapper.fromHeadersToReply(replyMessage.getHeaders(), (SoapMessage)response);
        }
    }

    protected abstract void doInvoke(MessageContext var1) throws Exception;
}

