/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.config;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class XmlPayloadValidatingFilterParser
extends AbstractConsumerEndpointParser {
    private static String SELECTOR_CLASSNAME = "org.springframework.integration.xml.selector.XmlValidatingMessageSelector";
    private static String FILTER_CLASSNAME = "org.springframework.integration.config.FilterFactoryBean";
    public static final String SCHEMA_W3C_XML = "http://www.w3.org/2001/XMLSchema";
    public static final String SCHEMA_RELAX_NG = "http://relaxng.org/ns/structure/1.0";

    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)FILTER_CLASSNAME);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)filterBuilder, (Element)element, (String)"discard-channel");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)filterBuilder, (Element)element, (String)"throw-exception-on-rejection");
        BeanDefinitionBuilder selectorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)SELECTOR_CLASSNAME);
        String validator = element.getAttribute("xml-validator");
        String schemaLocation = element.getAttribute("schema-location");
        boolean validatorDefined = StringUtils.hasText((String)validator);
        boolean schemaLocationDefined = StringUtils.hasText((String)schemaLocation);
        if (!(validatorDefined ^ schemaLocationDefined)) {
            throw new BeanDefinitionStoreException("Exactly one of 'xml-validator' or 'schema-location' is allowed on the 'validating-filter' element");
        }
        if (schemaLocationDefined) {
            selectorBuilder.addConstructorArgValue((Object)schemaLocation);
            String schemaType = "xml-schema".equals(element.getAttribute("schema-type")) ? SCHEMA_W3C_XML : SCHEMA_RELAX_NG;
            selectorBuilder.addConstructorArgValue((Object)schemaType);
        } else {
            selectorBuilder.addConstructorArgReference(validator);
        }
        selectorBuilder.addPropertyValue("throwExceptionOnRejection", (Object)element.getAttribute("throw-exception-on-rejection"));
        filterBuilder.addPropertyValue("targetObject", (Object)selectorBuilder.getBeanDefinition());
        return filterBuilder;
    }
}

