/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.xml.config.XPathExpressionParser;
import org.springframework.integration.xml.selector.BooleanTestXPathMessageSelector;
import org.springframework.integration.xml.selector.StringValueTestXPathMessageSelector;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XPathSelectorParser
extends AbstractSingleBeanDefinitionParser {
    private XPathExpressionParser xpathParser = new XPathExpressionParser();

    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String evaluationType = element.getAttribute("evaluation-result-type");
        String xPathExpressionRef = element.getAttribute("xpath-expression-ref");
        String stringTestValue = element.getAttribute("string-test-value");
        NodeList xPathExpressionNodes = element.getElementsByTagNameNS(element.getNamespaceURI(), "xpath-expression");
        Assert.isTrue((xPathExpressionNodes.getLength() <= 1 ? 1 : 0) != 0, (String)"At most one xpath-expression child may be specified.");
        boolean xPathExpressionChildPresent = xPathExpressionNodes.getLength() == 1;
        boolean xPathReferencePresent = StringUtils.hasText((String)xPathExpressionRef);
        Assert.isTrue((boolean)(xPathExpressionChildPresent ^ xPathReferencePresent), (String)"Exactly one of 'xpath-expression' or 'xpath-expression-ref' is required.");
        if (xPathExpressionChildPresent) {
            BeanDefinition beanDefinition = this.xpathParser.parse((Element)xPathExpressionNodes.item(0), parserContext);
            builder.addConstructorArgValue((Object)beanDefinition);
        } else {
            builder.addConstructorArgReference(xPathExpressionRef);
        }
        if (evaluationType.equals("boolean")) {
            builder.getBeanDefinition().setBeanClass(BooleanTestXPathMessageSelector.class);
            Assert.state((!StringUtils.hasText((String)stringTestValue) ? 1 : 0) != 0, (String)"'string-test-value' should not be specified when 'evaluation-result-type' is boolean");
        } else if (evaluationType.equals("string")) {
            Assert.hasText((String)stringTestValue, (String)"'string-test-value' must be specified when 'evaluation-result-type' is string");
            builder.addConstructorArgValue((Object)stringTestValue);
            builder.getBeanDefinition().setBeanClass(StringValueTestXPathMessageSelector.class);
        } else {
            throw new IllegalArgumentException("Unsupported value [" + evaluationType + "] for 'evaluation-result-type', expected boolean or string.");
        }
    }
}

