/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.transformer;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.transformer.AbstractTransformer;
import org.springframework.integration.xml.result.DomResultFactory;
import org.springframework.integration.xml.result.ResultFactory;
import org.springframework.integration.xml.transformer.ResultTransformer;
import org.springframework.oxm.Marshaller;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshallingTransformer
extends AbstractTransformer {
    private final Marshaller marshaller;
    private volatile ResultFactory resultFactory;
    private final ResultTransformer resultTransformer;
    private volatile boolean extractPayload = true;

    public MarshallingTransformer(Marshaller marshaller, ResultTransformer resultTransformer) throws ParserConfigurationException {
        Assert.notNull((Object)marshaller, (String)"a marshaller is required");
        this.marshaller = marshaller;
        this.resultTransformer = resultTransformer;
        this.resultFactory = new DomResultFactory();
    }

    public MarshallingTransformer(Marshaller marshaller) throws ParserConfigurationException {
        this(marshaller, null);
    }

    public void setResultFactory(ResultFactory resultFactory) {
        Assert.notNull((Object)resultFactory, (String)"ResultFactory must not be null");
        this.resultFactory = resultFactory;
    }

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    public Object doTransform(Message<?> message) {
        Object source = this.extractPayload ? message.getPayload() : message;
        Object transformedPayload = null;
        Result result = this.resultFactory.createResult(source);
        if (result == null) {
            throw new MessagingException("Unable to marshal payload, ResultFactory returned null.");
        }
        try {
            this.marshaller.marshal(source, result);
            transformedPayload = result;
        }
        catch (IOException e) {
            throw new MessagingException("Failed to marshal payload", (Throwable)e);
        }
        if (this.resultTransformer != null) {
            transformedPayload = this.resultTransformer.transformResult(result);
        }
        return transformedPayload;
    }
}

