/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.transformer;

import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.io.Resource;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.Message;
import org.springframework.integration.MessageHeaders;
import org.springframework.integration.MessagingException;
import org.springframework.integration.transformer.AbstractTransformer;
import org.springframework.integration.xml.result.DomResultFactory;
import org.springframework.integration.xml.result.ResultFactory;
import org.springframework.integration.xml.source.DomSourceFactory;
import org.springframework.integration.xml.source.SourceFactory;
import org.springframework.integration.xml.transformer.ResultTransformer;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.xml.transform.StringResult;
import org.springframework.xml.transform.StringSource;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsltPayloadTransformer
extends AbstractTransformer {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Templates templates;
    private final StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
    private Map<String, Expression> xslParameterMappings;
    private final ResultTransformer resultTransformer;
    private volatile SourceFactory sourceFactory = new DomSourceFactory();
    private volatile ResultFactory resultFactory = new DomResultFactory();
    private volatile boolean alwaysUseSourceFactory = false;
    private volatile boolean alwaysUseResultFactory = false;
    private volatile String[] xsltParamHeaders;

    public XsltPayloadTransformer(Templates templates) throws ParserConfigurationException {
        this(templates, null);
    }

    public XsltPayloadTransformer(Resource xslResource) throws Exception {
        this(TransformerFactory.newInstance().newTemplates(XsltPayloadTransformer.createStreamSourceOnResource(xslResource)), null);
    }

    public XsltPayloadTransformer(Resource xslResource, ResultTransformer resultTransformer) throws Exception {
        this(TransformerFactory.newInstance().newTemplates(XsltPayloadTransformer.createStreamSourceOnResource(xslResource)), resultTransformer);
    }

    public XsltPayloadTransformer(Templates templates, ResultTransformer resultTransformer) throws ParserConfigurationException {
        this.templates = templates;
        this.resultTransformer = resultTransformer;
        this.evaluationContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
    }

    public void setSourceFactory(SourceFactory sourceFactory) {
        Assert.notNull((Object)sourceFactory, (String)"SourceFactory must not be null");
        this.sourceFactory = sourceFactory;
    }

    public void setResultFactory(ResultFactory resultFactory) {
        Assert.notNull((Object)this.sourceFactory, (String)"ResultFactory must not be null");
        this.resultFactory = resultFactory;
    }

    public void setAlwaysUseSourceFactory(boolean alwaysUseSourceFactory) {
        this.alwaysUseSourceFactory = alwaysUseSourceFactory;
    }

    public void setAlwaysUseResultFactory(boolean alwaysUseResultFactory) {
        this.alwaysUseResultFactory = alwaysUseResultFactory;
    }

    public void setXslParameterMappings(Map<String, Expression> xslParameterMappings) {
        this.xslParameterMappings = xslParameterMappings;
    }

    public void setXsltParamHeaders(String[] xsltParamHeaders) {
        this.xsltParamHeaders = xsltParamHeaders;
    }

    public String getComponentType() {
        return "xml:xslt-transformer";
    }

    protected Object doTransform(Message<?> message) throws Exception {
        Transformer transformer = this.buildTransformer(message);
        Object payload = this.alwaysUseSourceFactory ? this.sourceFactory.createSource(message.getPayload()) : message.getPayload();
        Object transformedPayload = null;
        transformedPayload = this.alwaysUseResultFactory ? this.transformUsingResultFactory(payload, transformer) : (payload instanceof String ? this.transformString((String)payload, transformer) : (payload instanceof Document ? this.transformDocument((Document)payload, transformer) : (payload instanceof Source ? this.transformSource((Source)payload, payload, transformer) : this.transformUsingResultFactory(payload, transformer))));
        return transformedPayload;
    }

    private Object transformUsingResultFactory(Object payload, Transformer transformer) throws TransformerException {
        Object source = this.alwaysUseSourceFactory ? this.sourceFactory.createSource(payload) : (payload instanceof String ? new StringSource((String)payload) : (payload instanceof Document ? new DOMSource((Document)payload) : (payload instanceof Source ? (Source)payload : this.sourceFactory.createSource(payload))));
        return this.transformSource((Source)source, payload, transformer);
    }

    private Object transformSource(Source source, Object payload, Transformer transformer) throws TransformerException {
        Result result = this.resultFactory.createResult(payload);
        transformer.transform(source, result);
        if (this.resultTransformer != null) {
            return this.resultTransformer.transformResult(result);
        }
        return result;
    }

    private String transformString(String stringPayload, Transformer transformer) throws TransformerException {
        StringResult result = new StringResult();
        Source source = this.alwaysUseSourceFactory ? this.sourceFactory.createSource(stringPayload) : new StringSource(stringPayload);
        transformer.transform(source, (Result)result);
        return result.toString();
    }

    private Document transformDocument(Document documentPayload, Transformer transformer) throws TransformerException {
        Source source = this.alwaysUseSourceFactory ? this.sourceFactory.createSource(documentPayload) : new DOMSource(documentPayload);
        Result result = this.resultFactory.createResult(documentPayload);
        if (!DOMResult.class.isAssignableFrom(result.getClass())) {
            throw new MessagingException("Document to Document conversion requires a DOMResult-producing ResultFactory implementation.");
        }
        DOMResult domResult = (DOMResult)result;
        transformer.transform(source, domResult);
        return (Document)domResult.getNode();
    }

    private Transformer buildTransformer(Message<?> message) throws TransformerException {
        Transformer transformer = this.templates.newTransformer();
        if (this.xslParameterMappings != null) {
            for (String parameterName : this.xslParameterMappings.keySet()) {
                Expression expression = this.xslParameterMappings.get(parameterName);
                try {
                    Object value = expression.getValue((EvaluationContext)this.evaluationContext, message);
                    transformer.setParameter(parameterName, value);
                }
                catch (Exception e) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn((Object)("Evaluation of header expression '" + expression.getExpressionString() + "' failed. The XSLT parameter '" + parameterName + "' will be skipped."));
                }
            }
        }
        MessageHeaders headers = message.getHeaders();
        if (!ObjectUtils.isEmpty((Object[])this.xsltParamHeaders)) {
            for (String headerName : headers.keySet()) {
                if (!PatternMatchUtils.simpleMatch((String[])this.xsltParamHeaders, (String)headerName)) continue;
                transformer.setParameter(headerName, headers.get((Object)headerName));
            }
        }
        return transformer;
    }

    private static StreamSource createStreamSourceOnResource(Resource xslResource) throws IOException {
        try {
            String systemId = xslResource.getURI().toString();
            return new StreamSource(xslResource.getInputStream(), systemId);
        }
        catch (IOException e) {
            return new StreamSource(xslResource.getInputStream());
        }
    }
}

