/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.zip.transformer;

import java.io.File;
import java.nio.charset.Charset;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.transformer.AbstractTransformer;
import org.springframework.integration.zip.transformer.ZipResultType;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public abstract class AbstractZipTransformer
extends AbstractTransformer {
    protected Charset charset = Charset.defaultCharset();
    protected FileNameGenerator fileNameGenerator;
    protected ZipResultType zipResultType = ZipResultType.FILE;
    protected File workDirectory = new File(System.getProperty("java.io.tmpdir") + File.separator + "ziptransformer");
    protected boolean deleteFiles;

    public void setDeleteFiles(boolean deleteFiles) {
        this.deleteFiles = deleteFiles;
    }

    public void setWorkDirectory(File workDirectory) {
        Assert.notNull((Object)workDirectory, (String)"workDirectory must not be null.");
        Assert.isTrue((boolean)workDirectory.isDirectory(), (String)"The workDirectory specified must be a directory.");
        this.workDirectory = workDirectory;
    }

    public void setZipResultType(ZipResultType zipResultType) {
        Assert.notNull((Object)((Object)zipResultType), (String)"The zipResultType must not be empty.");
        this.zipResultType = zipResultType;
    }

    protected void onInit() {
        super.onInit();
        if (!this.workDirectory.exists()) {
            this.logger.info(() -> "Creating work directory: " + this.workDirectory);
            Assert.isTrue((boolean)this.workDirectory.mkdirs(), () -> "Can't create the 'workDirectory': " + this.workDirectory);
        }
        DefaultFileNameGenerator defaultFileNameGenerator = new DefaultFileNameGenerator();
        defaultFileNameGenerator.setBeanFactory(this.getBeanFactory());
        defaultFileNameGenerator.setConversionService(this.getConversionService());
        this.fileNameGenerator = defaultFileNameGenerator;
    }

    protected Object doTransform(Message<?> message) {
        return this.doZipTransform(message);
    }

    protected abstract Object doZipTransform(Message<?> var1);
}

