/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.test.utils;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.springframework.kafka.test.utils.KafkaTestUtils;
import org.springframework.util.ReflectionUtils;

public final class ContainerTestUtils {
    private ContainerTestUtils() {
    }

    public static void waitForAssignment(Object container, int partitions) throws Exception {
        if (container.getClass().getSimpleName().equals("KafkaMessageListenerContainer")) {
            ContainerTestUtils.waitForSingleContainerAssignment(container, partitions);
            return;
        }
        List containers = KafkaTestUtils.getPropertyValue(container, "containers", List.class);
        int n = 0;
        int count = 0;
        Method getAssignedPartitions = null;
        while (n++ < 600 && count < partitions) {
            count = 0;
            for (Object aContainer : containers) {
                Collection assignedPartitions;
                if (getAssignedPartitions == null) {
                    getAssignedPartitions = ContainerTestUtils.getAssignedPartitionsMethod(aContainer.getClass());
                }
                if ((assignedPartitions = (Collection)getAssignedPartitions.invoke(aContainer, new Object[0])) == null) continue;
                count += assignedPartitions.size();
            }
            if (count >= partitions) continue;
            Thread.sleep(100L);
        }
        Assertions.assertThat((int)count).isEqualTo(partitions);
    }

    private static void waitForSingleContainerAssignment(Object container, int partitions) throws Exception {
        int n = 0;
        int count = 0;
        Method getAssignedPartitions = ContainerTestUtils.getAssignedPartitionsMethod(container.getClass());
        while (n++ < 600 && count < partitions) {
            count = 0;
            Collection assignedPartitions = (Collection)getAssignedPartitions.invoke(container, new Object[0]);
            if (assignedPartitions != null) {
                count = assignedPartitions.size();
            }
            if (count >= partitions) continue;
            Thread.sleep(100L);
        }
        Assertions.assertThat((int)count).isEqualTo(partitions);
    }

    private static Method getAssignedPartitionsMethod(Class<?> clazz) {
        final AtomicReference theMethod = new AtomicReference();
        ReflectionUtils.doWithMethods(clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                theMethod.set(method);
            }
        }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                return method.getName().equals("getAssignedPartitions") && method.getParameterTypes().length == 0;
            }
        });
        Assertions.assertThat(theMethod.get()).isNotNull();
        return (Method)theMethod.get();
    }
}

