/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.Lifecycle;
import org.springframework.kafka.core.ProducerFactory;

public class DefaultKafkaProducerFactory<K, V>
implements ProducerFactory<K, V>,
Lifecycle,
DisposableBean {
    private static final int DEFAULT_PHYSICAL_CLOSE_TIMEOUT = 30;
    private static final Log logger = LogFactory.getLog(DefaultKafkaProducerFactory.class);
    private final Map<String, Object> configs;
    private volatile CloseSafeProducer<K, V> producer;
    private Serializer<K> keySerializer;
    private Serializer<V> valueSerializer;
    private int physicalCloseTimeout = 30;
    private volatile boolean running;

    public DefaultKafkaProducerFactory(Map<String, Object> configs) {
        this(configs, null, null);
    }

    public DefaultKafkaProducerFactory(Map<String, Object> configs, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.configs = new HashMap<String, Object>(configs);
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public void setKeySerializer(Serializer<K> keySerializer) {
        this.keySerializer = keySerializer;
    }

    public void setValueSerializer(Serializer<V> valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    public void setPhysicalCloseTimeout(int physicalCloseTimeout) {
        this.physicalCloseTimeout = physicalCloseTimeout;
    }

    public void destroy() throws Exception {
        CloseSafeProducer<K, V> producer = this.producer;
        this.producer = null;
        if (producer != null) {
            ((CloseSafeProducer)producer).delegate.close((long)this.physicalCloseTimeout, TimeUnit.SECONDS);
        }
    }

    public void start() {
        this.running = true;
    }

    public void stop() {
        try {
            this.destroy();
        }
        catch (Exception e) {
            logger.error((Object)"Exception while stopping producer", (Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Producer<K, V> createProducer() {
        if (this.producer == null) {
            DefaultKafkaProducerFactory defaultKafkaProducerFactory = this;
            synchronized (defaultKafkaProducerFactory) {
                if (this.producer == null) {
                    this.producer = new CloseSafeProducer<K, V>(this.createKafkaProducer());
                }
            }
        }
        return this.producer;
    }

    protected KafkaProducer<K, V> createKafkaProducer() {
        return new KafkaProducer(this.configs, this.keySerializer, this.valueSerializer);
    }

    private static class CloseSafeProducer<K, V>
    implements Producer<K, V> {
        private final Producer<K, V> delegate;

        CloseSafeProducer(Producer<K, V> delegate) {
            this.delegate = delegate;
        }

        public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
            return this.delegate.send(record);
        }

        public Future<RecordMetadata> send(ProducerRecord<K, V> record, Callback callback) {
            return this.delegate.send(record, callback);
        }

        public void flush() {
            this.delegate.flush();
        }

        public List<PartitionInfo> partitionsFor(String topic) {
            return this.delegate.partitionsFor(topic);
        }

        public Map<MetricName, ? extends Metric> metrics() {
            return this.delegate.metrics();
        }

        public void close() {
        }

        public void close(long timeout, TimeUnit unit) {
        }
    }
}

