/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.Producer;
import org.springframework.transaction.support.ResourceHolderSupport;
import org.springframework.util.Assert;

public class KafkaResourceHolder<K, V>
extends ResourceHolderSupport {
    private final Producer<K, V> producer;
    private final long closeTimeout;

    public KafkaResourceHolder(Producer<K, V> producer) {
        this(producer, 5000L);
    }

    public KafkaResourceHolder(Producer<K, V> producer, long closeTimeout) {
        Assert.notNull(producer, (String)"'producer' cannot be null");
        Assert.notNull((Object)closeTimeout, (String)"'closeTimeout' cannot be null");
        this.producer = producer;
        this.closeTimeout = closeTimeout;
    }

    public Producer<K, V> getProducer() {
        return this.producer;
    }

    public void commit() {
        this.producer.commitTransaction();
    }

    public void close() {
        this.producer.close(this.closeTimeout, TimeUnit.MILLISECONDS);
    }

    public void rollback() {
        this.producer.abortTransaction();
    }
}

