/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.springframework.kafka.support.KafkaNull;
import org.springframework.kafka.support.converter.ConversionException;
import org.springframework.kafka.support.converter.DefaultJackson2JavaTypeMapper;
import org.springframework.kafka.support.converter.Jackson2JavaTypeMapper;
import org.springframework.kafka.support.converter.MessagingMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class StringJsonMessageConverter
extends MessagingMessageConverter {
    private final ObjectMapper objectMapper;
    private Jackson2JavaTypeMapper typeMapper = new DefaultJackson2JavaTypeMapper();

    public StringJsonMessageConverter() {
        this(new ObjectMapper());
        this.objectMapper.configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public StringJsonMessageConverter(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null.");
        this.objectMapper = objectMapper;
    }

    public Jackson2JavaTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public void setTypeMapper(Jackson2JavaTypeMapper typeMapper) {
        Assert.notNull((Object)typeMapper, (String)"'typeMapper' cannot be null");
        this.typeMapper = typeMapper;
    }

    @Override
    protected Headers initialRecordHeaders(Message<?> message) {
        RecordHeaders headers = new RecordHeaders();
        this.typeMapper.fromClass(message.getPayload().getClass(), (Headers)headers);
        return headers;
    }

    @Override
    protected Object convertPayload(Message<?> message) {
        try {
            return this.objectMapper.writeValueAsString(message.getPayload());
        }
        catch (JsonProcessingException e) {
            throw new ConversionException("Failed to convert to JSON", e);
        }
    }

    @Override
    protected Object extractAndConvertValue(ConsumerRecord<?, ?> record, Type type) {
        JavaType javaType;
        Object value = record.value();
        if (record.value() == null) {
            return KafkaNull.INSTANCE;
        }
        JavaType javaType2 = javaType = this.typeMapper.getTypePrecedence().equals((Object)Jackson2JavaTypeMapper.TypePrecedence.INFERRED) ? TypeFactory.defaultInstance().constructType(type) : this.typeMapper.toJavaType(record.headers());
        if (javaType == null) {
            javaType = TypeFactory.defaultInstance().constructType(type);
        }
        if (value instanceof String) {
            try {
                return this.objectMapper.readValue((String)value, javaType);
            }
            catch (IOException e) {
                throw new ConversionException("Failed to convert from JSON", e);
            }
        }
        if (value instanceof byte[]) {
            try {
                return this.objectMapper.readValue((byte[])value, javaType);
            }
            catch (IOException e) {
                throw new ConversionException("Failed to convert from JSON", e);
            }
        }
        throw new IllegalStateException("Only String or byte[] supported");
    }
}

