/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.time.temporal.ValueRange;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.springframework.lang.Nullable;

class FailedRecordTracker {
    private final ThreadLocal<Map<TopicPartition, FailedRecord>> failures = new ThreadLocal();
    private final BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer;
    private final int maxFailures;
    private final boolean noRetries;
    private final Log logger;

    FailedRecordTracker(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, int maxFailures, Log logger) {
        this.recoverer = recoverer == null ? (r, t) -> logger.error((Object)("Max failures (" + maxFailures + ") reached for: " + r), (Throwable)t) : recoverer;
        this.maxFailures = maxFailures;
        this.noRetries = ValueRange.of(0L, 1L).isValidIntValue(maxFailures);
        this.logger = logger;
    }

    boolean skip(ConsumerRecord<?, ?> record, Exception exception) {
        TopicPartition topicPartition;
        FailedRecord failedRecord;
        if (this.noRetries) {
            this.recoverer.accept(record, exception);
            return true;
        }
        Map<TopicPartition, FailedRecord> map = this.failures.get();
        if (map == null) {
            this.failures.set(new HashMap());
            map = this.failures.get();
        }
        if ((failedRecord = map.get(topicPartition = new TopicPartition(record.topic(), record.partition()))) == null || failedRecord.getOffset() != record.offset()) {
            failedRecord = new FailedRecord(record.offset());
            map.put(topicPartition, failedRecord);
            return false;
        }
        if (this.maxFailures > 0 && failedRecord.incrementAndGet() >= this.maxFailures) {
            this.recoverer.accept(record, exception);
            map.remove(topicPartition);
            if (map.isEmpty()) {
                this.failures.remove();
            }
            return true;
        }
        return false;
    }

    void clearThreadState() {
        this.failures.remove();
    }

    private static final class FailedRecord {
        private final long offset;
        private int count;

        FailedRecord(long offset) {
            this.offset = offset;
            this.count = 1;
        }

        long getOffset() {
            return this.offset;
        }

        private int incrementAndGet() {
            return ++this.count;
        }
    }
}

