/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.AfterRollbackProcessor;
import org.springframework.kafka.listener.FailedRecordProcessor;
import org.springframework.kafka.listener.ListenerUtils;
import org.springframework.kafka.support.SeekUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.BackOffExecution;

public class DefaultAfterRollbackProcessor<K, V>
extends FailedRecordProcessor
implements AfterRollbackProcessor<K, V> {
    private final ThreadLocal<BackOffExecution> backOffs = new ThreadLocal();
    private final ThreadLocal<Long> lastIntervals = new ThreadLocal();
    private final BackOff backOff;
    private KafkaTemplate<K, V> kafkaTemplate;

    public DefaultAfterRollbackProcessor() {
        this(null, (BackOff)SeekUtils.DEFAULT_BACK_OFF);
    }

    @Deprecated
    public DefaultAfterRollbackProcessor(int maxFailures) {
        this(null, maxFailures);
    }

    public DefaultAfterRollbackProcessor(BackOff backOff) {
        this(null, backOff);
    }

    public DefaultAfterRollbackProcessor(BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer) {
        this(recoverer, (BackOff)SeekUtils.DEFAULT_BACK_OFF);
    }

    @Deprecated
    public DefaultAfterRollbackProcessor(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, int maxFailures) {
        super(recoverer, maxFailures);
        this.backOff = DefaultAfterRollbackProcessor.maxFailuresToBackOff(maxFailures);
    }

    public DefaultAfterRollbackProcessor(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, BackOff backOff) {
        super(recoverer, backOff);
        this.backOff = backOff;
    }

    @Override
    public void process(List<ConsumerRecord<K, V>> records, Consumer<K, V> consumer, Exception exception, boolean recoverable) {
        if (SeekUtils.doSeeks(records, consumer, exception, recoverable, this.getSkipPredicate(records, exception), this.logger) && this.isCommitRecovered() && this.kafkaTemplate != null && this.kafkaTemplate.isTransactional()) {
            ConsumerRecord<?, ?> skipped = records.get(0);
            this.kafkaTemplate.sendOffsetsToTransaction(Collections.singletonMap(new TopicPartition(skipped.topic(), skipped.partition()), new OffsetAndMetadata(skipped.offset() + 1L)));
        }
        if (!recoverable && this.backOff != null) {
            ListenerUtils.unrecoverableBackOff(this.backOff, this.backOffs, this.lastIntervals);
        }
    }

    @Override
    public boolean isProcessInTransaction() {
        return this.isCommitRecovered();
    }

    @Override
    public void setCommitRecovered(boolean commitRecovered) {
        super.setCommitRecovered(commitRecovered);
    }

    public void setKafkaTemplate(KafkaTemplate<K, V> kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }

    @Override
    public void clearThreadState() {
        super.clearThreadState();
        this.backOffs.remove();
        this.lastIntervals.remove();
    }
}

