/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.time.Duration;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.lang.Nullable;

public interface ProducerFactory<K, V> {
    public static final Duration DEFAULT_PHYSICAL_CLOSE_TIMEOUT = Duration.ofSeconds(30L);

    public Producer<K, V> createProducer();

    default public Producer<K, V> createProducer(String txIdPrefix) {
        throw new UnsupportedOperationException("This factory does not support this method");
    }

    default public Producer<K, V> createNonTransactionalProducer() {
        throw new UnsupportedOperationException("This factory does not support this method");
    }

    default public boolean transactionCapable() {
        return false;
    }

    default public void closeProducerFor(String transactionIdSuffix) {
    }

    default public boolean isProducerPerConsumerPartition() {
        return false;
    }

    default public void closeThreadBoundProducer() {
    }

    default public void reset() {
    }

    default public Map<String, Object> getConfigurationProperties() {
        throw new UnsupportedOperationException("This implementation doesn't support this method");
    }

    default public Supplier<Serializer<V>> getValueSerializerSupplier() {
        return () -> null;
    }

    default public Supplier<Serializer<K>> getKeySerializerSupplier() {
        return () -> null;
    }

    default public boolean isProducerPerThread() {
        return false;
    }

    @Nullable
    default public String getTransactionIdPrefix() {
        return null;
    }

    default public Duration getPhysicalCloseTimeout() {
        return DEFAULT_PHYSICAL_CLOSE_TIMEOUT;
    }

    public static interface Listener<K, V> {
        default public void producerAdded(String id, Producer<K, V> producer) {
        }

        default public void producerRemoved(String id, Producer<K, V> producer) {
        }
    }
}

