/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.listener.ConsumerSeekAware;
import org.springframework.lang.Nullable;

public abstract class AbstractConsumerSeekAware
implements ConsumerSeekAware {
    private final ThreadLocal<ConsumerSeekAware.ConsumerSeekCallback> callbackForThread = new ThreadLocal();
    private final Map<TopicPartition, ConsumerSeekAware.ConsumerSeekCallback> callbacks = new ConcurrentHashMap<TopicPartition, ConsumerSeekAware.ConsumerSeekCallback>();

    @Override
    public void registerSeekCallback(ConsumerSeekAware.ConsumerSeekCallback callback) {
        this.callbackForThread.set(callback);
    }

    @Override
    public void onPartitionsAssigned(Map<TopicPartition, Long> assignments, ConsumerSeekAware.ConsumerSeekCallback callback) {
        ConsumerSeekAware.ConsumerSeekCallback threadCallback = this.callbackForThread.get();
        if (threadCallback != null) {
            assignments.keySet().forEach(tp -> this.callbacks.put((TopicPartition)tp, threadCallback));
        }
    }

    @Override
    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
        partitions.forEach(tp -> this.callbacks.remove(tp));
    }

    @Override
    public void unregisterSeekCallback() {
        this.callbackForThread.remove();
    }

    @Nullable
    protected ConsumerSeekAware.ConsumerSeekCallback getSeekCallbackFor(TopicPartition topicPartition) {
        return this.callbacks.get(topicPartition);
    }

    protected Map<TopicPartition, ConsumerSeekAware.ConsumerSeekCallback> getSeekCallbacks() {
        return Collections.unmodifiableMap(this.callbacks);
    }
}

