/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.core.KafkaOperations;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.util.Assert;

public class RoutingKafkaTemplate
extends KafkaTemplate<Object, Object> {
    private final Map<Pattern, ProducerFactory<Object, Object>> factoryMatchers;
    private final ConcurrentMap<String, ProducerFactory<Object, Object>> factoryMap = new ConcurrentHashMap<String, ProducerFactory<Object, Object>>();

    public RoutingKafkaTemplate(Map<Pattern, ProducerFactory<Object, Object>> factories) {
        super(new ProducerFactory<Object, Object>(){

            @Override
            public Producer<Object, Object> createProducer() {
                throw new UnsupportedOperationException();
            }
        });
        this.factoryMatchers = new LinkedHashMap<Pattern, ProducerFactory<Object, Object>>(factories);
        Optional<Boolean> transactional = factories.values().stream().map(fact -> fact.transactionCapable()).findFirst();
        Assert.isTrue((!transactional.isPresent() || transactional.get() == false ? 1 : 0) != 0, (String)"Transactional factories are not supported");
    }

    @Override
    public ProducerFactory<Object, Object> getProducerFactory() {
        throw new UnsupportedOperationException("This method is not supported");
    }

    @Override
    public ProducerFactory<Object, Object> getProducerFactory(String topic) {
        ProducerFactory producerFactory = this.factoryMap.computeIfAbsent(topic, key -> {
            for (Map.Entry<Pattern, ProducerFactory<Object, Object>> entry : this.factoryMatchers.entrySet()) {
                if (!entry.getKey().matcher(topic).matches()) continue;
                return entry.getValue();
            }
            return null;
        });
        Assert.state((producerFactory != null ? 1 : 0) != 0, (String)("No producer factory found for topic: " + topic));
        return producerFactory;
    }

    @Override
    public <T> T execute(KafkaOperations.ProducerCallback<Object, Object, T> callback) {
        throw new UnsupportedOperationException("This method is not supported");
    }

    @Override
    public <T> T executeInTransaction(KafkaOperations.OperationsCallback<Object, Object, T> callback) {
        throw new UnsupportedOperationException("This method is not supported");
    }

    @Override
    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) {
        throw new UnsupportedOperationException("This method is not supported");
    }

    @Override
    public Map<MetricName, ? extends Metric> metrics() {
        throw new UnsupportedOperationException("This method is not supported");
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException("This method is not supported");
    }
}

