/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import java.util.Objects;
import java.util.function.BiPredicate;
import org.springframework.kafka.core.KafkaOperations;
import org.springframework.kafka.retrytopic.DltStrategy;

public class DestinationTopic {
    private final String destinationName;
    private final Properties properties;

    public DestinationTopic(String destinationName, Properties properties) {
        this.destinationName = destinationName;
        this.properties = properties;
    }

    public DestinationTopic(String destinationName, DestinationTopic sourceDestinationtopic, String suffix, Type type) {
        this.destinationName = destinationName;
        this.properties = new Properties(sourceDestinationtopic.properties, suffix, type);
    }

    public Long getDestinationDelay() {
        return this.properties.delayMs;
    }

    public Integer getDestinationPartitions() {
        return this.properties.numPartitions;
    }

    public boolean isAlwaysRetryOnDltFailure() {
        return DltStrategy.ALWAYS_RETRY_ON_ERROR.equals((Object)this.properties.dltStrategy);
    }

    public boolean isDltTopic() {
        return Type.DLT.equals((Object)this.properties.type);
    }

    public boolean isNoOpsTopic() {
        return Type.NO_OPS.equals((Object)this.properties.type);
    }

    public boolean isSingleTopicRetry() {
        return Type.SINGLE_TOPIC_RETRY.equals((Object)this.properties.type);
    }

    public boolean isMainTopic() {
        return Type.MAIN.equals((Object)this.properties.type);
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public KafkaOperations<?, ?> getKafkaOperations() {
        return this.properties.kafkaOperations;
    }

    public boolean shouldRetryOn(Integer attempt, Throwable e) {
        return this.properties.shouldRetryOn.test(attempt, e);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DestinationTopic that = (DestinationTopic)o;
        return this.destinationName.equals(that.destinationName) && this.properties.equals(that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.destinationName, this.properties);
    }

    public long getDestinationTimeout() {
        return this.properties.timeout;
    }

    static enum Type {
        MAIN,
        RETRY,
        SINGLE_TOPIC_RETRY,
        DLT,
        NO_OPS;

    }

    public static class Properties {
        private final long delayMs;
        private final String suffix;
        private final Type type;
        private final int maxAttempts;
        private final int numPartitions;
        private final DltStrategy dltStrategy;
        private final KafkaOperations<?, ?> kafkaOperations;
        private final BiPredicate<Integer, Throwable> shouldRetryOn;
        private final long timeout;

        public Properties(long delayMs, String suffix, Type type, int maxAttempts, int numPartitions, DltStrategy dltStrategy, KafkaOperations<?, ?> kafkaOperations, BiPredicate<Integer, Throwable> shouldRetryOn, long timeout) {
            this.delayMs = delayMs;
            this.suffix = suffix;
            this.type = type;
            this.maxAttempts = maxAttempts;
            this.numPartitions = numPartitions;
            this.dltStrategy = dltStrategy;
            this.kafkaOperations = kafkaOperations;
            this.shouldRetryOn = shouldRetryOn;
            this.timeout = timeout;
        }

        public Properties(Properties sourceProperties, String suffix, Type type) {
            this.delayMs = sourceProperties.delayMs;
            this.suffix = suffix;
            this.type = type;
            this.maxAttempts = sourceProperties.maxAttempts;
            this.numPartitions = sourceProperties.numPartitions;
            this.dltStrategy = sourceProperties.dltStrategy;
            this.kafkaOperations = sourceProperties.kafkaOperations;
            this.shouldRetryOn = sourceProperties.shouldRetryOn;
            this.timeout = sourceProperties.timeout;
        }

        public boolean isDltTopic() {
            return Type.DLT.equals((Object)this.type);
        }

        public String suffix() {
            return this.suffix;
        }

        public long delay() {
            return this.delayMs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Properties that = (Properties)o;
            return this.delayMs == that.delayMs && this.maxAttempts == that.maxAttempts && this.numPartitions == that.numPartitions && this.suffix.equals(that.suffix) && this.type == that.type && this.dltStrategy == that.dltStrategy && this.kafkaOperations.equals(that.kafkaOperations);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.delayMs, this.suffix, this.type, this.maxAttempts, this.numPartitions, this.dltStrategy, this.kafkaOperations});
        }

        public boolean isMainEndpoint() {
            return Type.MAIN.equals((Object)this.type);
        }
    }
}

