/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Collection;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import org.springframework.core.log.LogAccessor;

public interface ConsumerAwareRebalanceListener
extends ConsumerRebalanceListener {
    public static final LogAccessor LOGGER = new LogAccessor(LogFactory.getLog(ConsumerAwareRebalanceListener.class));

    default public void onPartitionsRevokedBeforeCommit(Consumer<?, ?> consumer, Collection<TopicPartition> partitions) {
        try {
            this.onPartitionsRevoked(partitions);
        }
        catch (Exception e) {
            LOGGER.debug((Throwable)e, (CharSequence)"User method threw exception");
        }
    }

    default public void onPartitionsRevokedAfterCommit(Consumer<?, ?> consumer, Collection<TopicPartition> partitions) {
    }

    default public void onPartitionsLost(Consumer<?, ?> consumer, Collection<TopicPartition> partitions) {
        try {
            this.onPartitionsLost(partitions);
        }
        catch (Exception e) {
            LOGGER.debug((Throwable)e, (CharSequence)"User method threw exception");
        }
    }

    default public void onPartitionsAssigned(Consumer<?, ?> consumer, Collection<TopicPartition> partitions) {
        try {
            this.onPartitionsAssigned(partitions);
        }
        catch (Exception e) {
            LOGGER.debug((Throwable)e, (CharSequence)"User method threw exception");
        }
    }

    default public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
    }

    default public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
    }

    default public void onPartitionsLost(Collection<TopicPartition> partitions) {
    }
}

