/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.annotation;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.annotation.RetryableTopic;
import org.springframework.kafka.annotation.RetryableTopicAnnotationProcessor;
import org.springframework.kafka.retrytopic.RetryTopicConfiguration;

public class RetryTopicConfigurationProvider {
    private final BeanFactory beanFactory;
    private final BeanExpressionResolver resolver;
    private final BeanExpressionContext expressionContext;
    private static final LogAccessor LOGGER = new LogAccessor(LogFactory.getLog(RetryTopicConfigurationProvider.class));

    public RetryTopicConfigurationProvider(BeanFactory beanFactory) {
        this(beanFactory, (BeanExpressionResolver)new StandardBeanExpressionResolver(), beanFactory instanceof ConfigurableBeanFactory ? new BeanExpressionContext((ConfigurableBeanFactory)beanFactory, null) : null);
    }

    public RetryTopicConfigurationProvider(BeanFactory beanFactory, BeanExpressionResolver resolver, BeanExpressionContext expressionContext) {
        this.beanFactory = beanFactory;
        this.resolver = resolver;
        this.expressionContext = expressionContext;
    }

    public RetryTopicConfiguration findRetryConfigurationFor(String[] topics, Method method, Object bean) {
        RetryableTopic annotation = (RetryableTopic)AnnotationUtils.findAnnotation((Method)method, RetryableTopic.class);
        return annotation != null ? new RetryableTopicAnnotationProcessor(this.beanFactory, this.resolver, this.expressionContext).processAnnotation(topics, method, annotation, bean) : this.maybeGetFromContext(topics);
    }

    private RetryTopicConfiguration maybeGetFromContext(String[] topics) {
        if (this.beanFactory == null || !ListableBeanFactory.class.isAssignableFrom(this.beanFactory.getClass())) {
            LOGGER.warn((CharSequence)"No ListableBeanFactory found, skipping RetryTopic configuration.");
            return null;
        }
        Map retryTopicProcessors = ((ListableBeanFactory)this.beanFactory).getBeansOfType(RetryTopicConfiguration.class);
        return retryTopicProcessors.values().stream().filter(topicConfiguration -> topicConfiguration.hasConfigurationForTopics(topics)).findFirst().orElse(null);
    }
}

