/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.BiFunction;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.springframework.kafka.support.serializer.DeserializationException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class SerializationUtils {
    public static final String DESERIALIZER_EXCEPTION_HEADER_PREFIX = "springDeserializerException";
    public static final String KEY_DESERIALIZER_EXCEPTION_HEADER = "springDeserializerExceptionKey";
    public static final String VALUE_DESERIALIZER_EXCEPTION_HEADER = "springDeserializerExceptionValue";

    private SerializationUtils() {
    }

    public static <P, T> BiFunction<P, Headers, T> propertyToMethodInvokingFunction(String methodProperty, Class<P> payloadType, ClassLoader classLoader) {
        Method method;
        Class clazz;
        int lastDotPosn = methodProperty.lastIndexOf(46);
        Assert.state((lastDotPosn > 1 ? 1 : 0) != 0, (String)"the method property needs to be a class name followed by the method name, separated by '.'");
        try {
            clazz = ClassUtils.forName((String)methodProperty.substring(0, lastDotPosn), (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException | LinkageError e) {
            throw new IllegalStateException(e);
        }
        String methodName = methodProperty.substring(lastDotPosn + 1);
        try {
            method = clazz.getDeclaredMethod(methodName, payloadType, Headers.class);
        }
        catch (NoSuchMethodException e) {
            try {
                method = clazz.getDeclaredMethod(methodName, payloadType);
            }
            catch (NoSuchMethodException e1) {
                IllegalStateException ise = new IllegalStateException("the parser method must take '(" + payloadType.getSimpleName() + ", Headers)' or '(" + payloadType.getSimpleName() + ")'", e1);
                ise.addSuppressed(e);
                throw ise;
            }
            catch (SecurityException e1) {
                IllegalStateException ise = new IllegalStateException(e1);
                ise.addSuppressed(e);
                throw ise;
            }
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        Method parseMethod = method;
        BiFunction<Object, Headers, Object> function = method.getParameters().length > 1 ? (str, headers) -> {
            try {
                return parseMethod.invoke(null, str, headers);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        } : (str, headers) -> {
            try {
                return parseMethod.invoke(null, str);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        };
        return function;
    }

    public static void deserializationException(Headers headers, byte[] data, Exception ex, boolean isForKeyArg) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DeserializationException exception = new DeserializationException("failed to deserialize", data, isForKeyArg, ex);
        try (ObjectOutputStream oos = new ObjectOutputStream(stream);){
            oos.writeObject((Object)exception);
        }
        catch (IOException ioex) {
            stream = new ByteArrayOutputStream();
            try (ObjectOutputStream oos2 = new ObjectOutputStream(stream);){
                exception = new DeserializationException("failed to deserialize", data, isForKeyArg, new RuntimeException("Could not deserialize type " + ioex.getClass().getName() + " with message " + ioex.getMessage() + " failure: " + ioex.getMessage()));
                oos2.writeObject((Object)exception);
            }
            catch (IOException ex2) {
                throw new IllegalStateException("Could not serialize a DeserializationException", ex2);
            }
        }
        headers.add((Header)new RecordHeader(isForKeyArg ? KEY_DESERIALIZER_EXCEPTION_HEADER : VALUE_DESERIALIZER_EXCEPTION_HEADER, stream.toByteArray()));
    }
}

