/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.listener.AcknowledgingConsumerAwareMessageListener;
import org.springframework.kafka.listener.AcknowledgingMessageListener;
import org.springframework.kafka.listener.BatchAcknowledgingConsumerAwareMessageListener;
import org.springframework.kafka.listener.BatchAcknowledgingMessageListener;
import org.springframework.kafka.listener.BatchConsumerAwareMessageListener;
import org.springframework.kafka.listener.ConsumerAwareMessageListener;
import org.springframework.kafka.listener.GenericMessageListener;
import org.springframework.kafka.listener.ListenerType;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.support.serializer.DeserializationException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.BackOffExecution;

public final class ListenerUtils {
    private static final ThreadLocal<Boolean> LOG_METADATA_ONLY = new ThreadLocal();
    private static final int DEFAULT_SLEEP_INTERVAL = 100;
    private static final int SMALL_SLEEP_INTERVAL = 10;
    private static final long SMALL_INTERVAL_THRESHOLD = 500L;

    private ListenerUtils() {
    }

    public static ListenerType determineListenerType(Object listener) {
        ListenerType listenerType;
        Assert.notNull((Object)listener, (String)"Listener cannot be null");
        if (listener instanceof AcknowledgingConsumerAwareMessageListener || listener instanceof BatchAcknowledgingConsumerAwareMessageListener) {
            listenerType = ListenerType.ACKNOWLEDGING_CONSUMER_AWARE;
        } else if (listener instanceof ConsumerAwareMessageListener || listener instanceof BatchConsumerAwareMessageListener) {
            listenerType = ListenerType.CONSUMER_AWARE;
        } else if (listener instanceof AcknowledgingMessageListener || listener instanceof BatchAcknowledgingMessageListener) {
            listenerType = ListenerType.ACKNOWLEDGING;
        } else if (listener instanceof GenericMessageListener) {
            listenerType = ListenerType.SIMPLE;
        } else {
            throw new IllegalArgumentException("Unsupported listener type: " + listener.getClass().getName());
        }
        return listenerType;
    }

    @Nullable
    public static DeserializationException getExceptionFromHeader(ConsumerRecord<?, ?> record, String headerName, LogAccessor logger) {
        Header header = record.headers().lastHeader(headerName);
        if (header != null) {
            byte[] value = header.value();
            DeserializationException exception = ListenerUtils.byteArrayToDeserializationException(logger, value);
            if (exception != null) {
                RecordHeaders headers = new RecordHeaders(record.headers().toArray());
                headers.remove(headerName);
                exception.setHeaders((Headers)headers);
            }
            return exception;
        }
        return null;
    }

    @Nullable
    public static DeserializationException byteArrayToDeserializationException(LogAccessor logger, byte[] value) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(value)){
                boolean first = true;

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    if (this.first) {
                        this.first = false;
                        Assert.state((boolean)desc.getName().equals(DeserializationException.class.getName()), (String)"Header does not contain a DeserializationException");
                    }
                    return super.resolveClass(desc);
                }
            };
            return (DeserializationException)((Object)ois.readObject());
        }
        catch (IOException | ClassCastException | ClassNotFoundException e) {
            logger.error((Throwable)e, (CharSequence)"Failed to deserialize a deserialization exception");
            return null;
        }
    }

    public static void setLogOnlyMetadata(boolean onlyMeta) {
        LOG_METADATA_ONLY.set(onlyMeta);
    }

    public static String recordToString(ConsumerRecord<?, ?> record) {
        if (Boolean.TRUE.equals(LOG_METADATA_ONLY.get())) {
            return record.topic() + "-" + record.partition() + "@" + record.offset();
        }
        return record.toString();
    }

    public static String recordToString(ConsumerRecord<?, ?> record, boolean meta) {
        if (meta) {
            return record.topic() + "-" + record.partition() + "@" + record.offset();
        }
        return record.toString();
    }

    @Deprecated
    public static void unrecoverableBackOff(BackOff backOff, ThreadLocal<BackOffExecution> executions, ThreadLocal<Long> lastIntervals) {
        try {
            ListenerUtils.unrecoverableBackOff(backOff, executions, lastIntervals, new MessageListenerContainer(){

                public void stop() {
                }

                public void start() {
                }

                public boolean isRunning() {
                    return true;
                }

                @Override
                public void setupMessageListener(Object messageListener) {
                }

                @Override
                public Map<String, Map<MetricName, ? extends Metric>> metrics() {
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void unrecoverableBackOff(BackOff backOff, ThreadLocal<BackOffExecution> executions, ThreadLocal<Long> lastIntervals, MessageListenerContainer container) throws InterruptedException {
        Long interval;
        BackOffExecution backOffExecution = executions.get();
        if (backOffExecution == null) {
            backOffExecution = backOff.start();
            executions.set(backOffExecution);
        }
        if ((interval = Long.valueOf(backOffExecution.nextBackOff())) == -1L && (interval = lastIntervals.get()) == null) {
            interval = 0L;
        }
        lastIntervals.set(interval);
        if (interval > 0L) {
            ListenerUtils.stoppableSleep(container, interval);
        }
    }

    public static void stoppableSleep(MessageListenerContainer container, long interval) throws InterruptedException {
        long timeout = System.currentTimeMillis() + interval;
        long sleepInterval = interval > 500L ? 100L : 10L;
        do {
            Thread.sleep(sleepInterval);
        } while (container.isRunning() && System.currentTimeMillis() < timeout);
    }
}

