/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.ListenerExecutionFailedException;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class CommonDelegatingErrorHandler
implements CommonErrorHandler {
    private final CommonErrorHandler defaultErrorHandler;
    private final Map<Class<? extends Throwable>, CommonErrorHandler> delegates = new LinkedHashMap<Class<? extends Throwable>, CommonErrorHandler>();

    public CommonDelegatingErrorHandler(CommonErrorHandler defaultErrorHandler) {
        Assert.notNull((Object)defaultErrorHandler, (String)"'defaultErrorHandler' cannot be null");
        this.defaultErrorHandler = defaultErrorHandler;
    }

    public void setErrorHandlers(Map<Class<? extends Throwable>, CommonErrorHandler> delegates) {
        this.delegates.clear();
        this.delegates.putAll(delegates);
        this.checkDelegates();
    }

    @Override
    public boolean remainingRecords() {
        return this.defaultErrorHandler.remainingRecords();
    }

    @Override
    public void clearThreadState() {
        this.defaultErrorHandler.clearThreadState();
        this.delegates.values().forEach(handler -> handler.clearThreadState());
    }

    @Override
    public boolean isAckAfterHandle() {
        return this.defaultErrorHandler.isAckAfterHandle();
    }

    @Override
    public void setAckAfterHandle(boolean ack) {
        this.defaultErrorHandler.setAckAfterHandle(ack);
    }

    public void addDelegate(Class<? extends Throwable> throwable, CommonErrorHandler handler) {
        this.delegates.put(throwable, handler);
        this.checkDelegates();
    }

    private void checkDelegates() {
        boolean remainingRecords = this.defaultErrorHandler.remainingRecords();
        boolean ackAfterHandle = this.defaultErrorHandler.isAckAfterHandle();
        this.delegates.values().forEach(handler -> {
            Assert.isTrue((remainingRecords == handler.remainingRecords() ? 1 : 0) != 0, (String)"All delegates must return the same value when calling 'remainingRecords()'");
            Assert.isTrue((ackAfterHandle == handler.isAckAfterHandle() ? 1 : 0) != 0, (String)"All delegates must return the same value when calling 'isAckAfterHandle()'");
        });
    }

    @Override
    public void handleRemaining(Exception thrownException, List<ConsumerRecord<?, ?>> records, Consumer<?, ?> consumer, MessageListenerContainer container) {
        CommonErrorHandler handler = this.findDelegate(thrownException);
        if (handler != null) {
            handler.handleRemaining(thrownException, records, consumer, container);
        } else {
            this.defaultErrorHandler.handleRemaining(thrownException, records, consumer, container);
        }
    }

    @Override
    public void handleBatch(Exception thrownException, ConsumerRecords<?, ?> data, Consumer<?, ?> consumer, MessageListenerContainer container, Runnable invokeListener) {
        CommonErrorHandler handler = this.findDelegate(thrownException);
        if (handler != null) {
            handler.handleBatch(thrownException, data, consumer, container, invokeListener);
        } else {
            this.defaultErrorHandler.handleBatch(thrownException, data, consumer, container, invokeListener);
        }
    }

    @Override
    public void handleOtherException(Exception thrownException, Consumer<?, ?> consumer, MessageListenerContainer container, boolean batchListener) {
        CommonErrorHandler handler = this.findDelegate(thrownException);
        if (handler != null) {
            handler.handleOtherException(thrownException, consumer, container, batchListener);
        } else {
            this.defaultErrorHandler.handleOtherException(thrownException, consumer, container, batchListener);
        }
    }

    @Nullable
    private CommonErrorHandler findDelegate(Throwable thrownException) {
        Throwable cause = thrownException;
        if (cause instanceof ListenerExecutionFailedException) {
            cause = thrownException.getCause();
        }
        if (cause != null) {
            Class<?> causeClass = cause.getClass();
            for (Map.Entry<Class<? extends Throwable>, CommonErrorHandler> entry : this.delegates.entrySet()) {
                if (!entry.getKey().isAssignableFrom(causeClass)) continue;
                return entry.getValue();
            }
        }
        return null;
    }
}

