/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.common.header.Header;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.support.KafkaHeaderMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;

public abstract class AbstractKafkaHeaderMapper
implements KafkaHeaderMapper {
    protected final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private final List<HeaderMatcher> matchers = new ArrayList<HeaderMatcher>();
    private final Map<String, Boolean> rawMappedHeaders = new HashMap<String, Boolean>();
    private boolean mapAllStringsOut;
    private Charset charset;

    public AbstractKafkaHeaderMapper(String ... patterns) {
        this.rawMappedHeaders.put("kafka_listenerInfo", true);
        this.charset = StandardCharsets.UTF_8;
        Assert.notNull((Object)patterns, (String)"'patterns' must not be null");
        this.matchers.add(new NeverMatchHeaderMatcher("kafka_acknowledgment", "kafka_consumer", "kafka_messageKey", "kafka_offset", "kafka_partitionId", "kafka_data", "kafka_receivedMessageKey", "kafka_receivedPartitionId", "kafka_receivedTimestamp", "kafka_receivedTopic", "kafka_timestamp", "kafka_timestampType", "kafka_batchConvertedHeaders", "kafka_nativeHeaders", "kafka_topic", "kafka_deliveryAttempt", "kafka_listenerInfo", "kafka_groupId"));
        for (String pattern : patterns) {
            this.matchers.add(new SimplePatternBasedHeaderMatcher(pattern));
        }
    }

    protected final void addMatchers(HeaderMatcher ... matchersToAdd) {
        Assert.notNull((Object)matchersToAdd, (String)"'matchersToAdd' cannot be null");
        Assert.noNullElements((Object[])matchersToAdd, (String)"'matchersToAdd' cannot have null elements");
        Collections.addAll(this.matchers, matchersToAdd);
    }

    public void setMapAllStringsOut(boolean mapAllStringsOut) {
        this.mapAllStringsOut = mapAllStringsOut;
    }

    protected Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        Assert.notNull((Object)charset, (String)"'charset' cannot be null");
        this.charset = charset;
    }

    public void setRawMappedHeaders(Map<String, Boolean> rawMappedHeaders) {
        if (!ObjectUtils.isEmpty(rawMappedHeaders)) {
            this.rawMappedHeaders.clear();
            this.rawMappedHeaders.putAll(rawMappedHeaders);
        }
    }

    public void addRawMappedHeader(String name, boolean toString) {
        this.rawMappedHeaders.put(name, toString);
    }

    protected boolean matches(String header, Object value) {
        if (this.matches(header)) {
            if ((header.equals("replyChannel") || header.equals("errorChannel")) && !(value instanceof String)) {
                this.logger.debug(() -> "Cannot map " + header + " when type is [" + value.getClass() + "]; it must be a String");
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean matches(String header) {
        for (HeaderMatcher matcher : this.matchers) {
            if (!matcher.matchHeader(header)) continue;
            return !matcher.isNegated();
        }
        this.logger.debug(() -> MessageFormat.format("headerName=[{0}] WILL NOT be mapped; matched no patterns", header));
        return false;
    }

    protected Object headerValueToAddOut(String key, Object value) {
        Object valueToAdd = this.mapRawOut(key, value);
        if (valueToAdd == null) {
            valueToAdd = value;
        }
        return valueToAdd;
    }

    @Nullable
    private byte[] mapRawOut(String header, Object value) {
        if (this.mapAllStringsOut || this.rawMappedHeaders.containsKey(header)) {
            if (value instanceof byte[]) {
                return (byte[])value;
            }
            if (value instanceof String) {
                return ((String)value).getBytes(this.charset);
            }
        }
        return null;
    }

    protected Object headerValueToAddIn(Header header) {
        Object mapped = this.mapRawIn(header.key(), header.value());
        if (mapped == null) {
            mapped = header.value();
        }
        return mapped;
    }

    @Nullable
    private String mapRawIn(String header, byte[] value) {
        Boolean asString = this.rawMappedHeaders.get(header);
        if (Boolean.TRUE.equals(asString)) {
            return new String(value, this.charset);
        }
        return null;
    }

    protected static class SimplePatternBasedHeaderMatcher
    implements HeaderMatcher {
        private static final LogAccessor LOGGER = new LogAccessor(LogFactory.getLog(SimplePatternBasedHeaderMatcher.class));
        private final String pattern;
        private final boolean negate;

        protected SimplePatternBasedHeaderMatcher(String pattern) {
            this(pattern.startsWith("!") ? pattern.substring(1) : pattern, pattern.startsWith("!"));
        }

        SimplePatternBasedHeaderMatcher(String pattern, boolean negate) {
            Assert.notNull((Object)pattern, (String)"Pattern must no be null");
            this.pattern = pattern.toLowerCase();
            this.negate = negate;
        }

        @Override
        public boolean matchHeader(String headerName) {
            String header = headerName.toLowerCase();
            if (PatternMatchUtils.simpleMatch((String)this.pattern, (String)header)) {
                LOGGER.debug(() -> MessageFormat.format("headerName=[{0}] WILL " + (this.negate ? "NOT " : "") + "be mapped, matched pattern=" + (this.negate ? "!" : "") + "{1}", headerName, this.pattern));
                return true;
            }
            return false;
        }

        @Override
        public boolean isNegated() {
            return this.negate;
        }
    }

    protected static class NeverMatchHeaderMatcher
    implements HeaderMatcher {
        private final Set<String> neverMatchHeaders;

        protected NeverMatchHeaderMatcher(String ... headers) {
            this.neverMatchHeaders = Arrays.stream(headers).collect(Collectors.toSet());
        }

        @Override
        public boolean matchHeader(String headerName) {
            return this.neverMatchHeaders.contains(headerName);
        }

        @Override
        public boolean isNegated() {
            return true;
        }
    }

    protected static interface HeaderMatcher {
        public boolean matchHeader(String var1);

        public boolean isNegated();
    }
}

