/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.support.SendResult;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.util.concurrent.ListenableFuture;

public interface KafkaOperations<K, V> {
    public static final Duration DEFAULT_POLL_TIMEOUT = Duration.ofSeconds(5L);

    public ListenableFuture<SendResult<K, V>> sendDefault(V var1);

    public ListenableFuture<SendResult<K, V>> sendDefault(K var1, V var2);

    public ListenableFuture<SendResult<K, V>> sendDefault(Integer var1, K var2, V var3);

    public ListenableFuture<SendResult<K, V>> sendDefault(Integer var1, Long var2, K var3, V var4);

    public ListenableFuture<SendResult<K, V>> send(String var1, V var2);

    public ListenableFuture<SendResult<K, V>> send(String var1, K var2, V var3);

    public ListenableFuture<SendResult<K, V>> send(String var1, Integer var2, K var3, V var4);

    public ListenableFuture<SendResult<K, V>> send(String var1, Integer var2, Long var3, K var4, V var5);

    public ListenableFuture<SendResult<K, V>> send(ProducerRecord<K, V> var1);

    public ListenableFuture<SendResult<K, V>> send(Message<?> var1);

    public List<PartitionInfo> partitionsFor(String var1);

    public Map<MetricName, ? extends Metric> metrics();

    @Nullable
    public <T> T execute(ProducerCallback<K, V, T> var1);

    @Nullable
    public <T> T executeInTransaction(OperationsCallback<K, V, T> var1);

    public void flush();

    @Deprecated
    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> var1);

    @Deprecated
    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> var1, String var2);

    default public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) {
        throw new UnsupportedOperationException();
    }

    public boolean isTransactional();

    default public boolean isAllowNonTransactional() {
        return false;
    }

    default public boolean inTransaction() {
        return false;
    }

    default public ProducerFactory<K, V> getProducerFactory() {
        throw new UnsupportedOperationException("This implementation does not support this operation");
    }

    @Nullable
    default public ConsumerRecord<K, V> receive(String topic, int partition, long offset) {
        return this.receive(topic, partition, offset, DEFAULT_POLL_TIMEOUT);
    }

    @Nullable
    public ConsumerRecord<K, V> receive(String var1, int var2, long var3, Duration var5);

    default public ConsumerRecords<K, V> receive(Collection<TopicPartitionOffset> requested) {
        return this.receive(requested, DEFAULT_POLL_TIMEOUT);
    }

    public ConsumerRecords<K, V> receive(Collection<TopicPartitionOffset> var1, Duration var2);

    public static interface OperationsCallback<K, V, T> {
        public T doInOperations(KafkaOperations<K, V> var1);
    }

    public static interface ProducerCallback<K, V, T> {
        public T doInKafka(Producer<K, V> var1);
    }
}

