/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.MethodParameter;
import org.springframework.core.log.LogAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.ConsumerSeekAware;
import org.springframework.kafka.listener.ListenerExecutionFailedException;
import org.springframework.kafka.listener.adapter.AdapterUtils;
import org.springframework.kafka.listener.adapter.ConsumerRecordMetadata;
import org.springframework.kafka.listener.adapter.HandlerAdapter;
import org.springframework.kafka.listener.adapter.InvocationResult;
import org.springframework.kafka.listener.adapter.ReplyHeadersConfigurer;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.kafka.support.KafkaNull;
import org.springframework.kafka.support.KafkaUtils;
import org.springframework.kafka.support.converter.MessagingMessageConverter;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.handler.annotation.support.MethodArgumentNotValidException;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class MessagingMessageListenerAdapter<K, V>
implements ConsumerSeekAware {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private static final Acknowledgment NO_OP_ACK = new NoOpAck();
    protected static final Message<KafkaNull> NULL_MESSAGE = new GenericMessage((Object)KafkaNull.INSTANCE);
    private final Object bean;
    protected final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private final Type inferredType;
    private final StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
    private HandlerAdapter handlerMethod;
    private boolean isConsumerRecordList;
    private boolean isConsumerRecords;
    private boolean isMessageList;
    private boolean conversionNeeded = true;
    private RecordMessageConverter messageConverter = new MessagingMessageConverter();
    private boolean converterSet;
    private Type fallbackType = Object.class;
    private Expression replyTopicExpression;
    private KafkaTemplate replyTemplate;
    private boolean hasAckParameter;
    private boolean noOpAck;
    private boolean hasMetadataParameter;
    private boolean messageReturnType;
    private ReplyHeadersConfigurer replyHeadersConfigurer;
    private boolean splitIterables = true;

    public MessagingMessageListenerAdapter(Object bean, Method method) {
        this.bean = bean;
        this.inferredType = this.determineInferredType(method);
    }

    public void setMessageConverter(RecordMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
        this.converterSet = true;
    }

    protected final RecordMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessagingConverter(SmartMessageConverter messageConverter) {
        Assert.isTrue((!this.converterSet ? 1 : 0) != 0, (String)"Cannot set the SmartMessageConverter when setting the messageConverter, add the SmartConverter to the message converter instead");
        ((MessagingMessageConverter)this.messageConverter).setMessagingConverter(messageConverter);
    }

    protected Type getType() {
        return this.inferredType == null ? this.fallbackType : this.inferredType;
    }

    public void setFallbackType(Class<?> fallbackType) {
        this.fallbackType = fallbackType;
    }

    public void setHandlerMethod(HandlerAdapter handlerMethod) {
        this.handlerMethod = handlerMethod;
    }

    protected boolean isConsumerRecordList() {
        return this.isConsumerRecordList;
    }

    public boolean isConsumerRecords() {
        return this.isConsumerRecords;
    }

    public boolean isConversionNeeded() {
        return this.conversionNeeded;
    }

    public void setReplyTopic(String replyTopicParam) {
        String replyTopic = replyTopicParam;
        if (!StringUtils.hasText((String)replyTopic)) {
            replyTopic = AdapterUtils.getDefaultReplyTopicExpression();
        }
        this.replyTopicExpression = replyTopic.contains(AdapterUtils.PARSER_CONTEXT.getExpressionPrefix()) ? PARSER.parseExpression(replyTopic, AdapterUtils.PARSER_CONTEXT) : new LiteralExpression(replyTopic);
    }

    public void setReplyTemplate(KafkaTemplate<?, ?> replyTemplate) {
        this.replyTemplate = replyTemplate;
    }

    public void setBeanResolver(BeanResolver beanResolver) {
        this.evaluationContext.setBeanResolver(beanResolver);
        this.evaluationContext.setTypeConverter((TypeConverter)new StandardTypeConverter());
        this.evaluationContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
    }

    protected boolean isMessageList() {
        return this.isMessageList;
    }

    protected ReplyHeadersConfigurer getReplyHeadersConfigurer() {
        return this.replyHeadersConfigurer;
    }

    public void setReplyHeadersConfigurer(ReplyHeadersConfigurer replyHeadersConfigurer) {
        this.replyHeadersConfigurer = replyHeadersConfigurer;
    }

    protected boolean isSplitIterables() {
        return this.splitIterables;
    }

    public void setSplitIterables(boolean splitIterables) {
        this.splitIterables = splitIterables;
    }

    @Override
    public void registerSeekCallback(ConsumerSeekAware.ConsumerSeekCallback callback) {
        if (this.bean instanceof ConsumerSeekAware) {
            ((ConsumerSeekAware)this.bean).registerSeekCallback(callback);
        }
    }

    @Override
    public void onPartitionsAssigned(Map<TopicPartition, Long> assignments, ConsumerSeekAware.ConsumerSeekCallback callback) {
        if (this.bean instanceof ConsumerSeekAware) {
            ((ConsumerSeekAware)this.bean).onPartitionsAssigned(assignments, callback);
        }
    }

    @Override
    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
        if (this.bean instanceof ConsumerSeekAware) {
            ((ConsumerSeekAware)this.bean).onPartitionsRevoked(partitions);
        }
    }

    @Override
    public void onIdleContainer(Map<TopicPartition, Long> assignments, ConsumerSeekAware.ConsumerSeekCallback callback) {
        if (this.bean instanceof ConsumerSeekAware) {
            ((ConsumerSeekAware)this.bean).onIdleContainer(assignments, callback);
        }
    }

    protected Message<?> toMessagingMessage(ConsumerRecord<K, V> record, @Nullable Acknowledgment acknowledgment, Consumer<?, ?> consumer) {
        return this.getMessageConverter().toMessage(record, acknowledgment, consumer, this.getType());
    }

    protected final Object invokeHandler(Object data, @Nullable Acknowledgment acknowledgment, Message<?> message, Consumer<?, ?> consumer) {
        Acknowledgment ack = acknowledgment;
        if (ack == null && this.noOpAck) {
            ack = NO_OP_ACK;
        }
        try {
            if (data instanceof List && !this.isConsumerRecordList) {
                return this.handlerMethod.invoke(message, ack, consumer);
            }
            if (this.hasMetadataParameter) {
                return this.handlerMethod.invoke(message, data, ack, consumer, AdapterUtils.buildConsumerRecordMetadata(data));
            }
            return this.handlerMethod.invoke(message, data, ack, consumer);
        }
        catch (MessageConversionException ex) {
            throw this.checkAckArg(ack, message, (Exception)((Object)new MessageConversionException("Cannot handle message", (Throwable)ex)));
        }
        catch (MethodArgumentNotValidException ex) {
            throw this.checkAckArg(ack, message, (Exception)((Object)ex));
        }
        catch (MessagingException ex) {
            throw new ListenerExecutionFailedException(this.createMessagingErrorMessage("Listener method could not be invoked with the incoming message", message.getPayload()), ex);
        }
        catch (Exception ex) {
            throw new ListenerExecutionFailedException("Listener method '" + this.handlerMethod.getMethodAsString(message.getPayload()) + "' threw exception", ex);
        }
    }

    private RuntimeException checkAckArg(@Nullable Acknowledgment acknowledgment, Message<?> message, Exception ex) {
        if (this.hasAckParameter && acknowledgment == null) {
            return new ListenerExecutionFailedException("invokeHandler Failed", new IllegalStateException("No Acknowledgment available as an argument, the listener container must have a MANUAL AckMode to populate the Acknowledgment.", ex));
        }
        return new ListenerExecutionFailedException(this.createMessagingErrorMessage("Listener method could not be invoked with the incoming message", message.getPayload()), ex);
    }

    protected void handleResult(Object resultArg, Object request, Object source) {
        this.logger.debug(() -> "Listener method returned result [" + resultArg + "] - generating response message for it");
        boolean isInvocationResult = resultArg instanceof InvocationResult;
        Object result = isInvocationResult ? ((InvocationResult)resultArg).getResult() : resultArg;
        String replyTopic = this.evaluateReplyTopic(request, source, resultArg);
        Assert.state((replyTopic == null || this.replyTemplate != null ? 1 : 0) != 0, (String)"a KafkaTemplate is required to support replies");
        this.sendResponse(result, replyTopic, source, isInvocationResult ? ((InvocationResult)resultArg).isMessageReturnType() : this.messageReturnType);
    }

    @Nullable
    private String evaluateReplyTopic(Object request, Object source, Object result) {
        String replyTo = null;
        if (result instanceof InvocationResult) {
            replyTo = this.evaluateTopic(request, source, result, ((InvocationResult)result).getSendTo());
        } else if (this.replyTopicExpression != null) {
            replyTo = this.evaluateTopic(request, source, result, this.replyTopicExpression);
        }
        return replyTo;
    }

    @Nullable
    private String evaluateTopic(Object request, Object source, Object result, @Nullable Expression sendTo) {
        if (sendTo instanceof LiteralExpression) {
            return (String)sendTo.getValue(String.class);
        }
        Object value = sendTo == null ? null : sendTo.getValue((EvaluationContext)this.evaluationContext, (Object)new ReplyExpressionRoot(request, source, result));
        boolean isByteArray = value instanceof byte[];
        if (value != null && !(value instanceof String) && !isByteArray) {
            throw new IllegalStateException("replyTopic expression must evaluate to a String or byte[], it is: " + value.getClass().getName());
        }
        if (isByteArray) {
            return new String((byte[])value, StandardCharsets.UTF_8);
        }
        return (String)value;
    }

    protected void sendResponse(Object result, String topic, @Nullable Object source, boolean returnTypeMessage) {
        if (!returnTypeMessage && topic == null) {
            this.logger.debug(() -> "No replyTopic to handle the reply: " + result);
        } else if (result instanceof Message) {
            Message<?> reply = this.checkHeaders(result, topic, source);
            this.replyTemplate.send(reply);
        } else if (result instanceof Iterable) {
            Iterator iterator = ((Iterable)result).iterator();
            boolean iterableOfMessages = false;
            if (iterator.hasNext()) {
                iterableOfMessages = iterator.next() instanceof Message;
            }
            if (iterableOfMessages || this.splitIterables) {
                ((Iterable)result).forEach(v -> {
                    if (v instanceof Message) {
                        this.replyTemplate.send((Message)v);
                    } else {
                        this.replyTemplate.send(topic, v);
                    }
                });
            } else {
                this.sendSingleResult(result, topic, source);
            }
        } else {
            this.sendSingleResult(result, topic, source);
        }
    }

    private Message<?> checkHeaders(Object result, String topic, Object source) {
        boolean needsPartition;
        Message reply = (Message)result;
        MessageHeaders headers = reply.getHeaders();
        boolean needsTopic = headers.get((Object)"kafka_topic") == null;
        boolean sourceIsMessage = source instanceof Message;
        boolean needsCorrelation = headers.get((Object)"kafka_correlationId") == null && sourceIsMessage;
        boolean bl = needsPartition = headers.get((Object)"kafka_partitionId") == null && sourceIsMessage && this.getReplyPartition((Message)source) != null;
        if (needsTopic || needsCorrelation || needsPartition) {
            MessageBuilder builder = MessageBuilder.fromMessage((Message)reply);
            if (needsTopic) {
                builder.setHeader("kafka_topic", (Object)topic);
            }
            if (needsCorrelation && sourceIsMessage) {
                builder.setHeader("kafka_correlationId", ((Message)source).getHeaders().get((Object)"kafka_correlationId"));
            }
            if (sourceIsMessage && reply.getHeaders().get((Object)"kafka_replyPartition") == null) {
                this.setPartition(builder, (Message)source);
            }
            reply = builder.build();
        }
        return reply;
    }

    private void sendSingleResult(Object result, String topic, @Nullable Object source) {
        byte[] correlationId = null;
        boolean sourceIsMessage = source instanceof Message;
        if (sourceIsMessage && ((Message)source).getHeaders().get((Object)"kafka_correlationId") != null) {
            correlationId = (byte[])((Message)source).getHeaders().get((Object)"kafka_correlationId", byte[].class);
        }
        if (sourceIsMessage) {
            this.sendReplyForMessageSource(result, topic, source, correlationId);
        } else {
            this.replyTemplate.send(topic, result);
        }
    }

    private void sendReplyForMessageSource(Object result, String topic, Object source, byte[] correlationId) {
        MessageBuilder builder = MessageBuilder.withPayload((Object)result).setHeader("kafka_topic", (Object)topic);
        if (this.replyHeadersConfigurer != null) {
            Map<String, Object> headersToCopy = ((Message)source).getHeaders().entrySet().stream().filter(e -> {
                String key = (String)e.getKey();
                return !key.equals("id") && !key.equals("timestamp") && !key.equals("kafka_correlationId") && !key.startsWith("kafka_received");
            }).filter(e -> this.replyHeadersConfigurer.shouldCopy((String)e.getKey(), e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (headersToCopy.size() > 0) {
                builder.copyHeaders(headersToCopy);
            }
            if (!ObjectUtils.isEmpty(headersToCopy = this.replyHeadersConfigurer.additionalHeaders())) {
                builder.copyHeaders(headersToCopy);
            }
        }
        if (correlationId != null) {
            builder.setHeader("kafka_correlationId", (Object)correlationId);
        }
        this.setPartition(builder, (Message)source);
        this.replyTemplate.send(builder.build());
    }

    private void setPartition(MessageBuilder<?> builder, Message<?> source) {
        byte[] partitionBytes = this.getReplyPartition(source);
        if (partitionBytes != null) {
            builder.setHeader("kafka_partitionId", (Object)ByteBuffer.wrap(partitionBytes).getInt());
        }
    }

    @Nullable
    private byte[] getReplyPartition(Message<?> source) {
        return (byte[])source.getHeaders().get((Object)"kafka_replyPartition", byte[].class);
    }

    protected final String createMessagingErrorMessage(String description, Object payload) {
        return description + "\nEndpoint handler details:\nMethod [" + this.handlerMethod.getMethodAsString(payload) + "]\nBean [" + this.handlerMethod.getBean() + "]";
    }

    protected Type determineInferredType(Method method) {
        boolean validParametersForBatch;
        if (method == null) {
            return null;
        }
        Type genericParameterType = null;
        int allowedBatchParameters = 1;
        int notConvertibleParameters = 0;
        for (int i = 0; i < method.getParameterCount(); ++i) {
            MethodParameter methodParameter = new MethodParameter(method, i);
            Type parameterType = methodParameter.getGenericParameterType();
            boolean isNotConvertible = MessagingMessageListenerAdapter.parameterIsType(parameterType, ConsumerRecord.class);
            boolean isAck = MessagingMessageListenerAdapter.parameterIsType(parameterType, Acknowledgment.class);
            this.hasAckParameter |= isAck;
            if (isAck) {
                this.noOpAck |= methodParameter.getParameterAnnotation(NonNull.class) != null;
            }
            isNotConvertible |= isAck;
            boolean isConsumer = MessagingMessageListenerAdapter.parameterIsType(parameterType, Consumer.class);
            isNotConvertible |= isConsumer;
            boolean isMeta = MessagingMessageListenerAdapter.parameterIsType(parameterType, ConsumerRecordMetadata.class);
            this.hasMetadataParameter |= isMeta;
            if (isNotConvertible |= isMeta) {
                ++notConvertibleParameters;
            }
            if (!(isNotConvertible || MessagingMessageListenerAdapter.isMessageWithNoTypeInfo(parameterType) || methodParameter.getParameterAnnotations().length != 0 && !methodParameter.hasParameterAnnotation(Payload.class))) {
                if (genericParameterType == null) {
                    genericParameterType = this.extractGenericParameterTypFromMethodParameter(methodParameter);
                    continue;
                }
                this.logger.debug(() -> "Ambiguous parameters for target payload for method " + method + "; no inferred type available");
                break;
            }
            if (isAck) {
                ++allowedBatchParameters;
                continue;
            }
            if (methodParameter.hasParameterAnnotation(Header.class)) {
                Header header = (Header)methodParameter.getParameterAnnotation(Header.class);
                if (header == null || !"kafka_groupId".equals(header.value())) continue;
                ++allowedBatchParameters;
                continue;
            }
            if (isConsumer) {
                ++allowedBatchParameters;
                continue;
            }
            if (!(parameterType instanceof ParameterizedType) || !((ParameterizedType)parameterType).getRawType().equals(Consumer.class)) continue;
            ++allowedBatchParameters;
        }
        if (notConvertibleParameters == method.getParameterCount() && method.getReturnType().equals(Void.TYPE)) {
            this.conversionNeeded = false;
        }
        boolean bl = validParametersForBatch = method.getGenericParameterTypes().length <= allowedBatchParameters;
        if (!validParametersForBatch) {
            String stateMessage = "A parameter of type '%s' must be the only parameter (except for an optional 'Acknowledgment' and/or 'Consumer' and/or '@Header(KafkaHeaders.GROUP_ID) String groupId'";
            Assert.state((!this.isConsumerRecords ? 1 : 0) != 0, () -> String.format(stateMessage, "ConsumerRecords"));
            Assert.state((!this.isConsumerRecordList ? 1 : 0) != 0, () -> String.format(stateMessage, "List<ConsumerRecord>"));
            Assert.state((!this.isMessageList ? 1 : 0) != 0, () -> String.format(stateMessage, "List<Message<?>>"));
        }
        this.messageReturnType = KafkaUtils.returnTypeMessageOrCollectionOf(method);
        return genericParameterType;
    }

    private Type extractGenericParameterTypFromMethodParameter(MethodParameter methodParameter) {
        Type genericParameterType = methodParameter.getGenericParameterType();
        if (genericParameterType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericParameterType;
            if (parameterizedType.getRawType().equals(Message.class)) {
                genericParameterType = ((ParameterizedType)genericParameterType).getActualTypeArguments()[0];
            } else if (parameterizedType.getRawType().equals(List.class) && parameterizedType.getActualTypeArguments().length == 1) {
                Type paramType = parameterizedType.getActualTypeArguments()[0];
                this.isConsumerRecordList = paramType.equals(ConsumerRecord.class) || this.isSimpleListOfConsumerRecord(paramType) || MessagingMessageListenerAdapter.isListOfConsumerRecordUpperBounded(paramType);
                boolean messageWithGeneric = MessagingMessageListenerAdapter.isMessageWithGeneric(paramType);
                boolean bl = this.isMessageList = paramType.equals(Message.class) || messageWithGeneric;
                if (messageWithGeneric) {
                    genericParameterType = MessagingMessageListenerAdapter.messagePayloadType(paramType);
                }
            } else {
                this.isConsumerRecords = parameterizedType.getRawType().equals(ConsumerRecords.class);
            }
        }
        return genericParameterType;
    }

    private static Type messagePayloadType(Type paramType) {
        if (paramType instanceof ParameterizedType) {
            return ((ParameterizedType)paramType).getActualTypeArguments()[0];
        }
        return ((ParameterizedType)((WildcardType)paramType).getUpperBounds()[0]).getActualTypeArguments()[0];
    }

    private static boolean isMessageWithGeneric(Type paramType) {
        return paramType instanceof ParameterizedType && ((ParameterizedType)paramType).getRawType().equals(Message.class) || MessagingMessageListenerAdapter.isWildCardWithUpperBound(paramType) && ((WildcardType)paramType).getUpperBounds()[0] instanceof ParameterizedType && ((ParameterizedType)((WildcardType)paramType).getUpperBounds()[0]).getRawType().equals(Message.class);
    }

    private boolean isSimpleListOfConsumerRecord(Type paramType) {
        return paramType instanceof ParameterizedType && ((ParameterizedType)paramType).getRawType().equals(ConsumerRecord.class);
    }

    private static boolean isListOfConsumerRecordUpperBounded(Type paramType) {
        return MessagingMessageListenerAdapter.isWildCardWithUpperBound(paramType) && ((WildcardType)paramType).getUpperBounds()[0] instanceof ParameterizedType && ((ParameterizedType)((WildcardType)paramType).getUpperBounds()[0]).getRawType().equals(ConsumerRecord.class);
    }

    private static boolean isWildCardWithUpperBound(Type paramType) {
        return paramType instanceof WildcardType && ((WildcardType)paramType).getUpperBounds() != null && ((WildcardType)paramType).getUpperBounds().length > 0;
    }

    private static boolean isMessageWithNoTypeInfo(Type parameterType) {
        ParameterizedType parameterizedType;
        Type rawType;
        if (parameterType instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)parameterType).getRawType()).equals(Message.class)) {
            return parameterizedType.getActualTypeArguments()[0] instanceof WildcardType;
        }
        return parameterType.equals(Message.class);
    }

    private static boolean parameterIsType(Type parameterType, Type type) {
        ParameterizedType parameterizedType;
        Type rawType;
        if (parameterType instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)parameterType).getRawType()).equals(type)) {
            return true;
        }
        return parameterType.equals(type);
    }

    static class NoOpAck
    implements Acknowledgment {
        NoOpAck() {
        }

        @Override
        public void acknowledge() {
        }
    }

    public static final class ReplyExpressionRoot {
        private final Object request;
        private final Object source;
        private final Object result;

        public ReplyExpressionRoot(Object request, Object source, Object result) {
            this.request = request;
            this.source = source;
            this.result = result;
        }

        public Object getRequest() {
            return this.request;
        }

        public Object getSource() {
            return this.source;
        }

        public Object getResult() {
            return this.result;
        }
    }
}

