/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.springframework.retry.backoff.BackOffContext;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.backoff.NoBackOffPolicy;
import org.springframework.retry.backoff.Sleeper;
import org.springframework.retry.backoff.SleepingBackOffPolicy;
import org.springframework.retry.backoff.UniformRandomBackOffPolicy;
import org.springframework.retry.support.RetrySynchronizationManager;

public class BackOffValuesGenerator {
    private static final BackOffPolicy DEFAULT_BACKOFF_POLICY = new FixedBackOffPolicy();
    private final int numberOfvaluesToCreate;
    private final BackOffPolicy backOffPolicy;

    public BackOffValuesGenerator(int providedMaxAttempts, BackOffPolicy providedBackOffPolicy) {
        this.numberOfvaluesToCreate = this.getMaxAttemps(providedMaxAttempts) - 1;
        BackOffPolicy policy = providedBackOffPolicy != null ? providedBackOffPolicy : DEFAULT_BACKOFF_POLICY;
        this.checkBackOffPolicyTipe(policy);
        this.backOffPolicy = policy;
    }

    public int getMaxAttemps(int providedMaxAttempts) {
        return providedMaxAttempts != -1 ? providedMaxAttempts : 3;
    }

    public List<Long> generateValues() {
        return NoBackOffPolicy.class.isAssignableFrom(this.backOffPolicy.getClass()) ? this.generateFromNoBackOffPolicy(this.numberOfvaluesToCreate) : this.generateFromSleepingBackOffPolicy(this.numberOfvaluesToCreate, this.backOffPolicy);
    }

    private void checkBackOffPolicyTipe(BackOffPolicy providedBackOffPolicy) {
        if (!SleepingBackOffPolicy.class.isAssignableFrom(providedBackOffPolicy.getClass()) && !NoBackOffPolicy.class.isAssignableFrom(providedBackOffPolicy.getClass())) {
            throw new IllegalArgumentException("Either a SleepingBackOffPolicy or a NoBackOffPolicy must be provided. Provided BackOffPolicy: " + providedBackOffPolicy.getClass().getSimpleName());
        }
    }

    private List<Long> generateFromSleepingBackOffPolicy(int maxAttempts, BackOffPolicy providedBackOffPolicy) {
        BackoffRetainerSleeper sleeper = new BackoffRetainerSleeper();
        SleepingBackOffPolicy retainingBackOffPolicy = ((SleepingBackOffPolicy)providedBackOffPolicy).withSleeper((Sleeper)sleeper);
        if (providedBackOffPolicy instanceof UniformRandomBackOffPolicy) {
            ((UniformRandomBackOffPolicy)retainingBackOffPolicy).setMaxBackOffPeriod(((UniformRandomBackOffPolicy)providedBackOffPolicy).getMaxBackOffPeriod());
        }
        BackOffContext backOffContext = retainingBackOffPolicy.start(RetrySynchronizationManager.getContext());
        IntStream.range(0, maxAttempts).forEach(index -> retainingBackOffPolicy.backOff(backOffContext));
        return sleeper.getBackoffValues();
    }

    private List<Long> generateFromNoBackOffPolicy(int maxAttempts) {
        return LongStream.range(0L, maxAttempts).mapToObj(index -> 0L).collect(Collectors.toList());
    }

    private static class BackoffRetainerSleeper
    implements Sleeper {
        private static final long serialVersionUID = 1L;
        private final List<Long> backoffValues = new ArrayList<Long>();

        private BackoffRetainerSleeper() {
        }

        public void sleep(long backOffPeriod) throws InterruptedException {
            this.backoffValues.add(backOffPeriod);
        }

        public List<Long> getBackoffValues() {
            return this.backoffValues;
        }
    }
}

