/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.kafka.retrytopic.DestinationTopic;
import org.springframework.kafka.retrytopic.DestinationTopicProcessor;
import org.springframework.kafka.retrytopic.DestinationTopicResolver;

public class DefaultDestinationTopicProcessor
implements DestinationTopicProcessor {
    private final DestinationTopicResolver destinationTopicResolver;

    public DefaultDestinationTopicProcessor(DestinationTopicResolver destinationTopicResolver) {
        this.destinationTopicResolver = destinationTopicResolver;
    }

    @Override
    public void processDestinationTopicProperties(Consumer<DestinationTopic.Properties> destinationPropertiesProcessor, DestinationTopicProcessor.Context context) {
        context.properties.stream().forEach(destinationPropertiesProcessor);
    }

    @Override
    public void registerDestinationTopic(String mainTopicName, String destinationTopicName, DestinationTopic.Properties destinationTopicProperties, DestinationTopicProcessor.Context context) {
        List topicDestinations = context.destinationsByTopicMap.computeIfAbsent(mainTopicName, newTopic -> new ArrayList());
        topicDestinations.add(new DestinationTopic(destinationTopicName, destinationTopicProperties));
    }

    @Override
    public void processRegisteredDestinations(Consumer<Collection<String>> topicsCallback, DestinationTopicProcessor.Context context) {
        context.destinationsByTopicMap.values().forEach(topicDestinations -> this.destinationTopicResolver.addDestinationTopics(context.listenerId, (List<DestinationTopic>)topicDestinations));
        topicsCallback.accept(this.getAllTopicsNamesForThis(context));
    }

    private List<String> getAllTopicsNamesForThis(DestinationTopicProcessor.Context context) {
        return context.destinationsByTopicMap.values().stream().flatMap(Collection::stream).map(DestinationTopic::getDestinationName).collect(Collectors.toList());
    }
}

