/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.springframework.kafka.listener.AcknowledgingConsumerAwareMessageListener;
import org.springframework.kafka.listener.AcknowledgingMessageListener;
import org.springframework.kafka.listener.BatchAcknowledgingConsumerAwareMessageListener;
import org.springframework.kafka.listener.BatchAcknowledgingMessageListener;
import org.springframework.kafka.listener.BatchConsumerAwareMessageListener;
import org.springframework.kafka.listener.ConsumerAwareMessageListener;
import org.springframework.kafka.listener.DefaultListenerMetadata;
import org.springframework.kafka.listener.GenericMessageListener;
import org.springframework.kafka.listener.ListenerType;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.OffsetAndMetadataProvider;
import org.springframework.util.Assert;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.BackOffExecution;

public final class ListenerUtils {
    private static final int DEFAULT_SLEEP_INTERVAL = 100;
    private static final int SMALL_SLEEP_INTERVAL = 10;
    private static final long SMALL_INTERVAL_THRESHOLD = 500L;

    private ListenerUtils() {
    }

    public static ListenerType determineListenerType(Object listener) {
        ListenerType listenerType;
        Assert.notNull((Object)listener, (String)"Listener cannot be null");
        if (listener instanceof AcknowledgingConsumerAwareMessageListener || listener instanceof BatchAcknowledgingConsumerAwareMessageListener) {
            listenerType = ListenerType.ACKNOWLEDGING_CONSUMER_AWARE;
        } else if (listener instanceof ConsumerAwareMessageListener || listener instanceof BatchConsumerAwareMessageListener) {
            listenerType = ListenerType.CONSUMER_AWARE;
        } else if (listener instanceof AcknowledgingMessageListener || listener instanceof BatchAcknowledgingMessageListener) {
            listenerType = ListenerType.ACKNOWLEDGING;
        } else if (listener instanceof GenericMessageListener) {
            listenerType = ListenerType.SIMPLE;
        } else {
            throw new IllegalArgumentException("Unsupported listener type: " + listener.getClass().getName());
        }
        return listenerType;
    }

    @Deprecated(since="3.1", forRemoval=true)
    public static void unrecoverableBackOff(BackOff backOff, ThreadLocal<BackOffExecution> executions, ThreadLocal<Long> lastIntervals, MessageListenerContainer container) throws InterruptedException {
        Long interval;
        BackOffExecution backOffExecution = executions.get();
        if (backOffExecution == null) {
            backOffExecution = backOff.start();
            executions.set(backOffExecution);
        }
        if ((interval = Long.valueOf(backOffExecution.nextBackOff())) == -1L && (interval = lastIntervals.get()) == null) {
            interval = 0L;
        }
        lastIntervals.set(interval);
        if (interval > 0L) {
            ListenerUtils.stoppableSleep(container, interval);
        }
    }

    public static void unrecoverableBackOff(BackOff backOff, Map<Thread, BackOffExecution> executions, Map<Thread, Long> lastIntervals, MessageListenerContainer container) throws InterruptedException {
        Long interval;
        Thread currentThread = Thread.currentThread();
        BackOffExecution backOffExecution = executions.get(currentThread);
        if (backOffExecution == null) {
            backOffExecution = backOff.start();
            executions.put(currentThread, backOffExecution);
        }
        if ((interval = Long.valueOf(backOffExecution.nextBackOff())) == -1L && (interval = lastIntervals.get(currentThread)) == null) {
            interval = 0L;
        }
        lastIntervals.put(currentThread, interval);
        if (interval > 0L) {
            ListenerUtils.stoppableSleep(container, interval);
        }
    }

    public static void stoppableSleep(MessageListenerContainer container, long interval) throws InterruptedException {
        ListenerUtils.conditionalSleep(() -> ((MessageListenerContainer)container).isRunning(), interval);
    }

    public static void conditionalSleep(Supplier<Boolean> shouldSleepCondition, long interval) throws InterruptedException {
        long timeout = System.currentTimeMillis() + interval;
        long sleepInterval = interval > 500L ? 100L : 10L;
        do {
            Thread.sleep(sleepInterval);
        } while (shouldSleepCondition.get().booleanValue() && System.currentTimeMillis() < timeout);
    }

    public static OffsetAndMetadata createOffsetAndMetadata(MessageListenerContainer container, long offset) {
        OffsetAndMetadataProvider metadataProvider = container.getContainerProperties().getOffsetAndMetadataProvider();
        if (metadataProvider != null) {
            return metadataProvider.provide(new DefaultListenerMetadata(container), offset);
        }
        return new OffsetAndMetadata(offset);
    }
}

