/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.time.Duration;
import org.apache.kafka.clients.producer.Producer;
import org.springframework.transaction.support.ResourceHolderSupport;
import org.springframework.util.Assert;

public class KafkaResourceHolder<K, V>
extends ResourceHolderSupport {
    private final Producer<K, V> producer;
    private final Duration closeTimeout;
    private boolean committed;

    public KafkaResourceHolder(Producer<K, V> producer, Duration closeTimeout) {
        Assert.notNull(producer, (String)"'producer' cannot be null");
        Assert.notNull((Object)closeTimeout, (String)"'closeTimeout' cannot be null");
        this.producer = producer;
        this.closeTimeout = closeTimeout;
    }

    public Producer<K, V> getProducer() {
        return this.producer;
    }

    public void commit() {
        if (!this.committed) {
            this.producer.commitTransaction();
            this.committed = true;
        }
    }

    public void close() {
        this.producer.close(this.closeTimeout);
    }

    public void rollback() {
        this.producer.abortTransaction();
    }
}

