/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Predicate;

public final class KafkaStreamBrancher<K, V> {
    private final List<Predicate<? super K, ? super V>> predicateList = new ArrayList<Predicate<? super K, ? super V>>();
    private final List<Consumer<? super KStream<K, V>>> consumerList = new ArrayList<Consumer<? super KStream<K, V>>>();
    private Consumer<? super KStream<K, V>> defaultConsumer;

    public KafkaStreamBrancher<K, V> branch(Predicate<? super K, ? super V> predicate, Consumer<? super KStream<K, V>> consumer) {
        this.predicateList.add(Objects.requireNonNull(predicate));
        this.consumerList.add(Objects.requireNonNull(consumer));
        return this;
    }

    public KafkaStreamBrancher<K, V> defaultBranch(Consumer<? super KStream<K, V>> consumer) {
        this.defaultConsumer = Objects.requireNonNull(consumer);
        return this;
    }

    public KStream<K, V> onTopOf(KStream<K, V> stream) {
        if (this.defaultConsumer != null) {
            this.predicateList.add((k, v) -> true);
            this.consumerList.add(this.defaultConsumer);
        }
        Predicate[] predicates = this.predicateList.toArray(new Predicate[0]);
        KStream[] result = stream.branch(predicates);
        for (int i = 0; i < this.consumerList.size(); ++i) {
            this.consumerList.get(i).accept(result[i]);
        }
        return stream;
    }
}

