/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.kafka.KafkaClientMetrics;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;
import org.jspecify.annotations.Nullable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public abstract class KafkaMetricsSupport<C> {
    protected final MeterRegistry meterRegistry;
    protected final List<Tag> tags;
    protected final @Nullable ScheduledExecutorService scheduler;
    private final Map<String, MeterBinder> metrics = new HashMap<String, MeterBinder>();

    protected KafkaMetricsSupport(MeterRegistry meterRegistry) {
        this(meterRegistry, Collections.emptyList());
    }

    protected KafkaMetricsSupport(MeterRegistry meterRegistry, TaskScheduler taskScheduler) {
        this(meterRegistry, Collections.emptyList(), taskScheduler);
    }

    protected KafkaMetricsSupport(MeterRegistry meterRegistry, List<Tag> tags) {
        Assert.notNull((Object)meterRegistry, (String)"The 'meterRegistry' cannot be null");
        this.meterRegistry = meterRegistry;
        this.tags = tags;
        this.scheduler = null;
    }

    protected KafkaMetricsSupport(MeterRegistry meterRegistry, List<Tag> tags, TaskScheduler taskScheduler) {
        Assert.notNull((Object)meterRegistry, (String)"The 'meterRegistry' cannot be null");
        Assert.notNull((Object)taskScheduler, (String)"The 'taskScheduler' cannot be null");
        this.meterRegistry = meterRegistry;
        this.tags = tags;
        this.scheduler = KafkaMetricsSupport.obtainScheduledExecutorService(taskScheduler);
    }

    protected final void bindClient(String id, C client) {
        if (!this.metrics.containsKey(id)) {
            ArrayList<Tag> clientTags = new ArrayList<Tag>(this.tags);
            clientTags.add((Tag)new ImmutableTag("spring.id", id));
            this.metrics.put(id, this.createClientMetrics(client, clientTags));
            this.metrics.get(id).bindTo(this.meterRegistry);
        }
    }

    protected MeterBinder createClientMetrics(C client, List<Tag> tags) {
        if (client instanceof Consumer) {
            Consumer consumer = (Consumer)client;
            return this.createConsumerMetrics(consumer, tags);
        }
        if (client instanceof Producer) {
            Producer producer = (Producer)client;
            return this.createProducerMetrics(producer, tags);
        }
        if (client instanceof AdminClient) {
            AdminClient admin = (AdminClient)client;
            return this.createAdminMetrics(admin, tags);
        }
        throw new IllegalArgumentException("Unsupported client type: " + String.valueOf(client.getClass()));
    }

    private KafkaClientMetrics createConsumerMetrics(Consumer<?, ?> consumer, List<Tag> tags) {
        return this.scheduler != null ? new KafkaClientMetrics(consumer, tags, this.scheduler) : new KafkaClientMetrics(consumer, tags);
    }

    private KafkaClientMetrics createProducerMetrics(Producer<?, ?> producer, List<Tag> tags) {
        return this.scheduler != null ? new KafkaClientMetrics(producer, tags, this.scheduler) : new KafkaClientMetrics(producer, tags);
    }

    private KafkaClientMetrics createAdminMetrics(AdminClient adminClient, List<Tag> tags) {
        return this.scheduler != null ? new KafkaClientMetrics(adminClient, tags, this.scheduler) : new KafkaClientMetrics(adminClient, tags);
    }

    protected final void unbindClient(@Nullable String id, C client) {
        AutoCloseable removed = (AutoCloseable)this.metrics.remove(id);
        if (removed != null) {
            try {
                removed.close();
            }
            catch (Exception ex) {
                ReflectionUtils.rethrowRuntimeException((Throwable)ex);
            }
        }
    }

    private static ScheduledExecutorService obtainScheduledExecutorService(TaskScheduler taskScheduler) {
        if (taskScheduler instanceof ThreadPoolTaskScheduler) {
            ThreadPoolTaskScheduler threadPoolTaskScheduler = (ThreadPoolTaskScheduler)taskScheduler;
            return threadPoolTaskScheduler.getScheduledExecutor();
        }
        return new ScheduledExecutorServiceAdapter(taskScheduler);
    }

    private static final class ScheduledExecutorServiceAdapter
    extends ScheduledThreadPoolExecutor {
        private final TaskScheduler delegate;

        private ScheduledExecutorServiceAdapter(TaskScheduler delegate) {
            super(0);
            this.delegate = delegate;
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this.delegate.scheduleAtFixedRate(command, Instant.now().plus(initialDelay, unit.toChronoUnit()), Duration.of(period, unit.toChronoUnit()));
        }
    }
}

