/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.time.Duration;
import org.apache.kafka.clients.producer.Producer;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.core.KafkaResourceHolder;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.transaction.support.ResourceHolderSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public final class ProducerFactoryUtils {
    public static final Duration DEFAULT_CLOSE_TIMEOUT = Duration.ofSeconds(5L);

    private ProducerFactoryUtils() {
    }

    public static <K, V> KafkaResourceHolder<K, V> getTransactionalResourceHolder(ProducerFactory<K, V> producerFactory) {
        return ProducerFactoryUtils.getTransactionalResourceHolder(producerFactory, null, DEFAULT_CLOSE_TIMEOUT);
    }

    public static <K, V> KafkaResourceHolder<K, V> getTransactionalResourceHolder(ProducerFactory<K, V> producerFactory, Duration closeTimeout) {
        return ProducerFactoryUtils.getTransactionalResourceHolder(producerFactory, null, closeTimeout);
    }

    public static <K, V> KafkaResourceHolder<K, V> getTransactionalResourceHolder(ProducerFactory<K, V> producerFactory, @Nullable String txIdPrefix, Duration closeTimeout) {
        Assert.notNull(producerFactory, (String)"ProducerFactory must not be null");
        KafkaResourceHolder<K, V> resourceHolder = (KafkaResourceHolder<K, V>)((Object)TransactionSynchronizationManager.getResource(producerFactory));
        if (resourceHolder == null) {
            Producer<K, V> producer = producerFactory.createProducer(txIdPrefix);
            try {
                producer.beginTransaction();
            }
            catch (RuntimeException e) {
                producer.close(closeTimeout);
                throw e;
            }
            resourceHolder = new KafkaResourceHolder<K, V>(producer, closeTimeout);
            ProducerFactoryUtils.bindResourceToTransaction(resourceHolder, producerFactory);
        }
        return resourceHolder;
    }

    public static <K, V> void releaseResources(@Nullable KafkaResourceHolder<K, V> resourceHolder) {
        if (resourceHolder != null) {
            resourceHolder.close();
        }
    }

    private static <K, V> void bindResourceToTransaction(KafkaResourceHolder<K, V> resourceHolder, ProducerFactory<K, V> producerFactory) {
        TransactionSynchronizationManager.bindResource(producerFactory, resourceHolder);
        resourceHolder.setSynchronizedWithTransaction(true);
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization(new KafkaResourceSynchronization<K, V>(resourceHolder, producerFactory));
        }
    }

    private static final class KafkaResourceSynchronization<K, V>
    extends ResourceHolderSynchronization<KafkaResourceHolder<K, V>, Object> {
        private final KafkaResourceHolder<K, V> resourceHolder;

        KafkaResourceSynchronization(KafkaResourceHolder<K, V> resourceHolder, Object resourceKey) {
            super(resourceHolder, resourceKey);
            this.resourceHolder = resourceHolder;
        }

        protected boolean shouldReleaseBeforeCompletion() {
            return false;
        }

        protected void processResourceAfterCommit(KafkaResourceHolder<K, V> resourceHolder) {
            resourceHolder.commit();
        }

        public void afterCompletion(int status) {
            try {
                if (status == 0) {
                    this.resourceHolder.commit();
                } else {
                    this.resourceHolder.rollback();
                }
            }
            finally {
                super.afterCompletion(status);
            }
        }

        protected void releaseResource(KafkaResourceHolder<K, V> holder, Object resourceKey) {
            ProducerFactoryUtils.releaseResources(holder);
        }
    }
}

