/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.streams;

import java.util.Properties;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyQueryMetadata;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.state.HostInfo;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.config.StreamsBuilderFactoryBean;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class KafkaStreamsInteractiveQueryService {
    private final StreamsBuilderFactoryBean streamsBuilderFactoryBean;
    private RetryTemplate retryTemplate = new RetryTemplate();
    private volatile @Nullable KafkaStreams kafkaStreams;

    public KafkaStreamsInteractiveQueryService(StreamsBuilderFactoryBean streamsBuilderFactoryBean) {
        Assert.notNull((Object)((Object)streamsBuilderFactoryBean), (String)"StreamsBuildFactoryBean instance cannot be null.");
        this.streamsBuilderFactoryBean = streamsBuilderFactoryBean;
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        Assert.notNull((Object)retryTemplate, (String)"The provided RetryTemplate instance must not be null");
        this.retryTemplate = retryTemplate;
    }

    public <T> T retrieveQueryableStore(String storeName, QueryableStoreType<T> storeType) {
        this.populateKafkaStreams();
        StoreQueryParameters storeQueryParams = StoreQueryParameters.fromNameAndType((String)storeName, storeType);
        return (T)this.retryTemplate.execute(context -> {
            try {
                Assert.state((this.kafkaStreams != null ? 1 : 0) != 0, (String)"KafkaStreams cannot be null.");
                return this.kafkaStreams.store(storeQueryParams);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error retrieving state store: " + storeName, e);
            }
        });
    }

    private void populateKafkaStreams() {
        if (this.kafkaStreams == null) {
            this.kafkaStreams = this.streamsBuilderFactoryBean.getKafkaStreams();
        }
        Assert.notNull((Object)this.kafkaStreams, (String)"KafkaStreams cannot be null. Make sure that the corresponding StreamsBuilderFactoryBean has started properly.");
    }

    public @Nullable HostInfo getCurrentKafkaStreamsApplicationHostInfo() {
        String applicationServer;
        String[] appServerComponents;
        Properties streamsConfiguration = this.streamsBuilderFactoryBean.getStreamsConfiguration();
        if (streamsConfiguration != null && streamsConfiguration.containsKey("application.server") && (appServerComponents = StringUtils.split((String)(applicationServer = (String)streamsConfiguration.get("application.server")), (String)":")) != null) {
            return new HostInfo(appServerComponents[0], Integer.parseInt(appServerComponents[1]));
        }
        return null;
    }

    public <K> HostInfo getKafkaStreamsApplicationHostInfo(String store, K key, Serializer<K> serializer) {
        this.populateKafkaStreams();
        return (HostInfo)this.retryTemplate.execute(context -> {
            Exception throwable = null;
            try {
                Assert.state((this.kafkaStreams != null ? 1 : 0) != 0, (String)"KafkaStreams cannot be null.");
                KeyQueryMetadata keyQueryMetadata = this.kafkaStreams.queryMetadataForKey(store, key, serializer);
                if (keyQueryMetadata != null) {
                    return keyQueryMetadata.activeHost();
                }
            }
            catch (Exception e) {
                throwable = e;
            }
            throw new IllegalStateException("Error when retrieving state store.", throwable != null ? throwable : new Throwable("KeyQueryMetadata is not yet available."));
        });
    }
}

